page 50, 130

;FILE - driver.asm
;
; This is a very simple character-mode DOS device driver
; The purpose of this driver is to examine the behavior of the DOS
; Protected Mode Interface in Windows 3.0.  The driver runs as a real-
; mode application, but can exchange data with the Protected Mode
; Windows application.
;
; To generate the installable device driver,
; MASM dd.asm
; LINK dd
; EXE2BIN dd.exe dd.sys

lptno           EQU  0
INCLUDE         display.mac             ;output routines

stackseg        SEGMENT STACK           ;Unused stack segment
stackseg        ENDS

codeseg         SEGMENT 'CODE'          ;Start of code segment
                ASSUME  cs:codeseg      ;Tell assembler
                ORG 0                   ;Zero out the position counter

                dd  -1                  ;Device header
                                        ;Points to next device header
                                        ;-1 indicates that there are no
                                        ;other headers in this file
                dw  0C800h              ;Attribute word
                                        ;SET:
                                        ;Bit 15 - 1 = character device
                                        ;Bit 14 - 1 = supports IOCL
                                        ;Bit 11 - 1 = supports open/close
                                        ;NOTE: bit 11 only works if DOS
                                        ;ver. 3.0 or higher.
                                        ;functions 3 & 12
                                        ;NOT SET:
                                        ;Bit 13 - 1 = supports o/p until
                                        ;busy.  Function 16.
                                        ;removable media (functions 13, 14, 15)
                                        ;Bit 6  - 1 = supports get/set logical
                                        ;device.  Functions 23 & 24
                                        ;Bit 3  - 1 = current clock device
                                        ;Bit 2  - 1 = current NUL device
                                        ;Bit 1  - 1 = current standard
                                        ;output device
                                        ;Bit 0  - 1 = character:standard input
                                        ;device.
                                        ;All other bits must be 0
                dw  strategy            ;Forward reference to strategy routine
                dw  interrupt           ;Forward reference to interrupt routine
                db  'RMDRIVER'          ;8 byte character device name
                                        ;Call table, for use by interrupt
                                        ;service routine
                                        ;Num:Function
calltable       dw  init                ;0    Initialization
                dw  invalid             ;1    Media check (block mode only)
                dw  invalid             ;2    Build BIOS parameter block
                                        ;(block mode only)
                dw  ioctl_out           ;3    Output IOCTL string to app.
                dw  io_read             ;4    Read data from device
                dw  nondes_in           ;5    Non-destructive input
                dw  input_stat          ;6    Input status
                dw  input_flush         ;7    Input flush
                dw  io_write            ;8    Write data to device
                dw  out_ver             ;9    Output with verify
                dw  out_stat            ;10   Output status
                dw  out_flush           ;11   Output flush
                dw  ioctl_in            ;12   Input IOCTL string to driver
                dw  dev_open            ;13   Device open
                dw  dev_close           ;14   Device close
                dw  invalid             ;15   Removable media (block only)
                dw  out_busy            ;16   Output until busy
                dw  invalid             ;17   illegal function
                dw  invalid             ;18   illegal function
                dw  invalid             ;19   Generic IOCTL request (block)
                dw  invalid             ;20   illegal function
                dw  invalid             ;21   illegal function
                dw  invalid             ;22   illegal function
                dw  invalid             ;23   Get logical device (block)
                dw  invalid             ;24   Set logical device (block)

                                        ;Long address of request header
rh_off          dw  ?                   ;offset
rh_seg          dw  ?                   ;segment

old_sp          dw  ?                   ;old sp
old_ss          dw  ?                   ;old ss
old_bp          dw  ?                   ;old bp
endstack        db  100 DUP (?)         ;set up a local stack
localstack:

INCLUDE         rh.asm                  ;structure declarations for device
                                        ;driver

strategy        PROC  FAR               ;Strategy routine is always called
                mov  cs:rh_off, bx      ;first by DOS.  Must save request
                mov  cs:rh_seg, es      ;header and issue a far return.
                ret
strategy        ENDP

interrupt       PROC  FAR               ;interrupt routine
                mov   cs:old_sp, sp     ;set up local stack
                mov   cs:old_bp, bp     ;save bp of caller
                mov   cs:old_ss, ss     ;save ss of caller
                mov   bp, cs            ;new stack segment
                mov   ss, bp
                mov   bp, OFFSET localstack  ;new base and stack pointer
                mov   sp, OFFSET localstack

                push  ax                ;save machine state
                push  bx
                push  cx
                push  dx
                push  si
                push  di
                push  ds
                push  es
                pushf
                les   di, DWORD PTR cs:rh_off
                                        ;es:si now points to request header
                                        ;May now use rheader (in rh.asm)
                                        ;to access the fields
                mov   al, rheader.rh_command
                                        ;get command code
                cbw                     ;extend al to WORD in ax
                                        ;sign extend
                cmp   ax, lastcmd       ;verify that command is in range
                jbe   j01               ;valid command
                call  invalid           ;invalid command
                jmp   j02
j01:            shl   ax, 1             ;calculate offset in call table
                mov   bx, ax            ;load address register
                call  cs:calltable[bx]  ;call appropriate service routine
j02:            or    ax, MASK done     ;set the 'done' bit in the status
                                        ;field of the common header
                mov   rheader.rh_status, ax
                popf                    ;restore machine state
                pop   es
                pop   ds
                pop   di
                pop   si
                pop   dx
                pop   cx
                pop   bx
                pop   ax

                mov   sp, cs:old_sp        ;restore system stack
                mov   bp, cs:old_bp
                mov   ss, cs:old_ss
                ret                        ;far return to DOS
interrupt       ENDP

;INTERRUPT SERVICE ROUTINES
ioctl_out       PROC  NEAR              ;export ioctl control string to
                xor   ax, ax            ;application
                ret
ioctl_out       ENDP
io_read         PROC  NEAR              ;read data from device, place in
                jmp   SHORT ior01       ;buffer for application to read
ior_data        db    "This string is exported by the driver", 0
ior01:
                push  ds                ;save modified registers
                push  di
                push  bx
                push  cx
                printstr <"RMDRIVER: Received Read Request",13,10>
                mov   bx, 0             ;bx will be used to count the bytes
                                        ;read
                lds   di, DWORD PTR rheader.io_bufptr ;ds:di has address of
                                                      ;transfer buffer
                printstr <"        ", "RMDRIVER: Buffer segment:offset - ">
                printh   ds
                printstr <":">
                printh   di
                printstr <13, 10>
ior02:          mov   cl, ior_data[bx]  ;next byte to read into buffer
                mov   BYTE PTR ds:[di+bx], cl    ;move next byte
                inc   bx                ;bump counter by one
                cmp   cl, 0             ;terminating null reached?
                jg    ior02             ;do next byte
                mov   WORD PTR rheader.io_count, bx   ;bytes transferred
                pop   cx                ;done - restore registers
                pop   bx
                pop   di
                pop   ds
                xor   ax, ax            ;return success (0)
                ret
io_read         ENDP
nondes_in       PROC  NEAR              ;non-destructive input from device
                xor   ax, ax
                ret
nondes_in       ENDP
input_stat      PROC  NEAR              ;input status- report to DOS if
                xor   ax, ax            ;data is available in the input buf.
                ret
input_stat      ENDP
input_flush     PROC  NEAR              ;input flush-flush the input buffer
                xor   ax, ax
                ret
input_flush     ENDP
io_write        PROC  NEAR              ;receives data from the application
                jmp   SHORT iow01       ;for writing to device
iow_data        db    100 DUP(0)        ;input buffer
iow01:
                push  ds                ;save machine state
                push  di
                push  bx
                push  cx
                printstr <"RMDRIVER: Received Write Request",13,10>
                mov   bx, 0             ;bx will count the bytes written
                lds   di, DWORD PTR rheader.io_bufptr ;ds:di has address of
                                                      ;transfer buffer
                printstr <"        ", "RMDRIVER: Buffer segment:offset - ">
                printh   ds
                printstr <":">
                printh   di
                printstr <13, 10>
iow02:          mov   cl, BYTE PTR ds:[di+bx] ;write next byte
                mov   iow_data[bx], cl  ;move next byte to buffer
                inc   bx                ;bump counter by one
                cmp   cl, 0             ;terminating null reached?
                mov   al, cl            ;character to print
                mov    ah, 0            ;print the character
                mov    dx, lptno        ;assumes port is available for
                                        ;printing
                int    17h              ;BIOS print routine invoked
                jg    iow02             ;do next byte
                mov   WORD PTR rheader.io_count, bx   ;bytes transferred
                printstr <13, 10>
                pop   cx                ;done - restore registers
                pop   bx
                pop   di
                pop   ds
                xor   ax, ax            ;return 0 - success
                ret
io_write        ENDP

out_ver         PROC  NEAR              ;output with verify
                xor   ax, ax
                ret
out_ver         ENDP
out_stat        PROC  NEAR              ;output status
                xor   ax, ax
                ret
out_stat        ENDP
out_flush       PROC  NEAR              ;output flush
                xor   ax, ax
                ret
out_flush       ENDP
ioctl_in        PROC  NEAR              ;input IOCTL control string to driver
                xor   ax, ax
                ret
ioctl_in        ENDP
dev_open        PROC  NEAR              ;device open
                printstr <"RMDRIVER: Opened",13,10>
                xor   ax, ax
                ret
dev_open        ENDP
dev_close       PROC  NEAR              ;device close
                printstr <"RMDRIVER: Closed",13,10>
                xor   ax, ax
                ret
dev_close       ENDP
out_busy        PROC  NEAR              ;output until busy
                xor   ax, ax
                ret
out_busy        ENDP
invalid         PROC  NEAR              ;invalid function
                printstr <"RMDRIVER: Unsupported function",13,10>
                mov   ax, 03            ;set error code - unknown function
                or    ax, MASK error     ;set error bit
                ret
invalid         ENDP

int6b_off       dw    ?                 ;segment of next int6b handler in chain
int6b_seg       dw    ?                 ;offset of next int6b handler in chain
int6bproc       PROC  FAR               ;int6b handler
                sti
                mov   cs:old_sp, sp  ;set up local stack
                mov   cs:old_bp, bp  ;save old bp
                mov   cs:old_ss, ss  ;save old ss
                mov   bp, cs         ;set new bp, sp, ss
                mov   ss, bp
                mov   bp, OFFSET localstack
                mov   sp, OFFSET localstack

                ;print registers of interest
                printstr <"RMDRIVER: Received INT 6bh",13,10>
                printstr <"        ", "RMDRIVER: AX, BX, CX, DX: ">
                printh   ax
                printstr <", ">
                printh   bx
                printstr <", ">
                printh   cx
                printstr <", ">
                printh   dx
                printstr <13, 10>
                printstr <"        ", "RMDRIVER: SI, DI: ">
                printh   si
                printstr <", ">
                printh   di
                printstr <13, 10>
                printstr <"        ", "RMDRIVER: DS, ES: ">
                printh   ds
                printstr <", ">
                printh   es
                printstr <13, 10>
                mov   sp, cs:old_sp        ;restore system stack
                mov   bp, cs:old_bp
                mov   ss, cs:old_ss

                jmp   DWORD PTR int6b_off ;branch to default handler
                                          ;it will do iret
int6bproc       ENDP

localdata       db    "This data is contained in the device-driver segment "
                db    "In order to access it, the application must perform "
                db    "an INT 6a and receive back a pointer.  The protected "
                db    "mode program must then convert the pointer to a "
                db    "selector and assume ownership of it.", 0
int6aproc       PROC  FAR               ;intab handler
                sti
                mov   cs:old_sp, sp  ;set up local stack
                mov   cs:old_bp, bp  ;save old bp
                mov   cs:old_ss, ss  ;save old ss
                mov   bp, cs         ;set new bp, sp, ss
                mov   ss, bp
                mov   bp, OFFSET localstack
                mov   sp, OFFSET localstack

                mov   bx, cs
                mov   es, bx
                mov   bx, OFFSET localdata
                ;print pointer to local data
                printstr <"RMDRIVER: Received INT 6ah",13,10>
                printstr <"        ", "RMDRIVER: Pointer to local data ">
                printh   es
                printstr <":">
                printh   bx
                printstr <13, 10>
                mov   sp, cs:old_sp        ;restore system stack
                mov   bp, cs:old_bp
                mov   ss, cs:old_ss

                iret
int6aproc       ENDP

;Driver Initialization procedure
init            PROC  NEAR
COMMENT *
                Function 0, the initialization routine, is called only once
                by DOS, and therefore need not remain resident in memory.
                It must perform any necessary device initialization, and
                return to DOS the first address beyond the portion of code
                to be retained in memory.
                *
                push bx                 ;save registers
                push cx
                push dx
                push ds
                                        ;prompt driver loaded
                dispstr <13,10,"RMDRIVER Installed", 13,10>

;Return break address to DOS
;All code after 'init' is discarded
                mov  WORD PTR rheader.in_endaddr, OFFSET init
                mov  WORD PTR rheader.in_endaddr+2, cs

                mov  ah, 1              ;initialize the printer port
                mov  dx, lptno          ;
                int  17h

                mov  ah, 35h            ;save address of next handler
                mov  al, 6bh            ;int number
                int  21h                ;use this address to chain to
                                        ;next handler when done local
                                        ;processing
                mov  WORD PTR int6b_seg, es
                mov  WORD PTR int6b_off, bx

                mov  ah, 25h            ;revector to our int6b handler
                mov  al, 6bh            ;int number
                mov  dx, cs             ;segment of new handler
                mov  ds, dx
                mov  dx, OFFSET int6bproc  ;offset of new handler
                int  21h

                mov  ah, 25h            ;revector to our int6a handler
                mov  al, 6ah            ;int number
                mov  dx, cs             ;segment of new handler
                mov  ds, dx
                mov  dx, OFFSET int6aproc  ;offset of new handler
                int  21h

                xor  ax, ax             ;return 0 - success
                pop  ds                 ;restore registers
                pop  dx
                pop  cx
                pop  bx
                ret
init            ENDP

codeseg         ENDS
                END

