#include <dos.h>
#include <windows.h>
#include "dpmi.h"

//Simulate real mode interrupt from protected mode Windows
BOOL dpmiRMInt(WORD wIntno, WORD wFlags, RM386_INT far *rmInt, WORD wStackVals)
{
    if (wFlags)
    {
        wIntno |= 0x100;
    } //End if (flags set)

    _asm
    {
        push di
        mov  ax, 0300h
        mov  bx, word ptr wIntno
        mov  cx, word ptr wStackVals
        les  di, dword ptr rmInt
        int  31h
        jc   error
        mov  ax, 1
        jmp  short done
    } //End (low-level dpmi real-mode interrupt)
error:
    _asm xor ax, ax
done:
    _asm pop di

} //End function (dpmiRMInt)

//Get the DPMI version number, processor type
BOOL dpmiVersion (WORD *wFlags, WORD *wMajor, WORD *wMinor, WORD *wProcessor)
{
BYTE bMaj, bMin, bProc;
WORD wFl;
BOOL bRval;

    _asm
    {
        mov ax, 1686h
        int 2fh
        not ax
        mov bRval, ax
    } //End (determine if dpmi is present)
    if (!bRval)
    {
        return FALSE;
    } //End if (dpmi not present)

    _asm
    {
        mov ax, 0400h
        int 31h
        mov bProc,  cl
        mov wFl,  bx
        mov bMaj, ah
        mov bMin, al
    } //End (get version information)
    *wProcessor = bProc;
    *wFlags     = wFl;
    *wMinor     = bMin;
    *wMajor     = bMaj;

     return TRUE;
} //End function (dpmiVersion)

//Allocate a single LDT selector
SELECTOR dpmiAllocNewSelector (void)
{
    _asm
    {
        xor ax, ax
        mov cx, 1
        int 31h
        jc  error
        jmp short done
    } //End (get selector)
error:
    _asm xor ax, ax
done:;
} //End function (dpmiAllocNewSelector)

//Assign new descriptor to our application
BOOL dpmiSetDescriptor (SELECTOR slSelector, PM_DESCRIPTOR far *pmDescriptor)
{
    _asm
    {
        mov  bx, WORD PTR slSelector
        mov  ax, 000ch
        push di
        les  di, DWORD PTR pmDescriptor
        int  31h
        jc   error
        mov  ax, 1
        jmp  short done
    } //End (set descriptor)
error:
    _asm xor ax, ax
done:
    _asm pop di
} //End function (dpmiSetDescriptor)

//Read a descriptor from our application
BOOL dpmiReadDescriptor (SELECTOR slSelector, PM_DESCRIPTOR far *pmDescriptor)
{
    _asm
    {
        mov  bx, WORD PTR slSelector
        mov  ax, 000bh
        push di
        les  di, DWORD PTR pmDescriptor
        int  31h
        jc   error
        mov  ax, 1
        jmp  short done
    } //End (read descriptor)
error:
    _asm xor ax, ax
done:
    _asm pop di
} //End function (dpmiReadDescriptor)

//Free an LDT selector
BOOL dpmiFreeSelector (SELECTOR slSelector)
{
    _asm
    {
        mov ax, 0001h
        mov bx, WORD PTR slSelector
        int 31h
        jc  error
        mov ax,1
        jmp short done
    } //End (free selector)
error:
    _asm xor ax, ax
done:;
} //End function (dpmiFreeSelector)
/****************************************************************************

    FUNCTION:  dpmiSegmentToSelector

    PURPOSE:  Converts a real-mode segment to a protected-mode selector,
              and gives the application access to that selector.
    COMMENTS:


****************************************************************************/
BOOL dpmiSegmentToSelector (SEGMENT sgSegment, DWORD dwBytes, SELECTOR *slSelector)
{
PM_DESCRIPTOR pmdDescriptor;
LPSTR lpPointDS = (LPSTR) &pmdDescriptor;
char szMessage[528];

    //Allocate new selector (with permissions belonging to this application)
    if ((*slSelector = dpmiAllocNewSelector())==0)
    {
        return FAILURE;
    } //End if (could not allocate new selector)
    //Get descriptor for data segment this program is using
    //FP_SEG returns the selector of this program's data segment
    //when applied to any far pointer in the program.
    if (!dpmiReadDescriptor(FP_SEG(lpPointDS), &pmdDescriptor))
    {
        return FAILURE;
    } //End if (could not read descriptor for program's data segment)
    //Use the same permissions for new descriptor.  Modify limit
    //and address fields.
    pmdDescriptor.byte_limit = dwBytes -1;
    //Set lo, hi, and xhi addresses in the screwy 32 bit descriptor format
    vSetRMDescriptorAddr (sgSegment, &pmdDescriptor);
    if (!dpmiSetDescriptor (*slSelector, &pmdDescriptor))
    {
        return FAILURE;
    } //End if (could not set new descriptor)
    return SUCCESS;
} //End function (dpmiRealToSelector)

void vSetRMDescriptorAddr (SEGMENT sgSeg, PM_DESCRIPTOR *pmdD)
{
DWORD  dw32bitOffset;
    //Offsets in 32 bit 386 mode are 32 bits.  Real-mode segments
    //are 16 bit paragraph addresses, which correlate to 20bit
    //memory addresses in the lower 1MB range by performing a
    //4 bit left shift.
    dw32bitOffset = ((DWORD) sgSeg) << 4;
    //Now for the screwy descriptor format:
    //lo address is lower WORD of 32 bit offset
    pmdD->lo_addr = (WORD) dw32bitOffset;
    //hi address is anything in excess of 16 bits
    pmdD->hi_addr = (BYTE) (dw32bitOffset >> 16);
    //Can't get at memory addressed by this byte in real mode
    pmdD->xhi_addr = (BYTE) 0;

} //End function (vSetRMDescriptorAddr)
