/* DPMI.H */
#pragma pack(1)

#define SUCCESS     1
#define FAILURE     !SUCCESS

/* selector, segment, and offset types */
typedef WORD SELECTOR;
typedef WORD SEGMENT;
typedef WORD OFFSET;
/* Structure for making RM interrupts from 386 protected mode */
typedef struct {
    DWORD edi, esi, ebp, reserved, ebx, edx, ecx, eax;
    WORD flags, es, ds, fs, gs, ip, cs, sp, ss;
    } RM386_INT;

/* Structure of a protected mode descriptor */
typedef struct {
    WORD byte_limit, lo_addr;
    BYTE hi_addr, permissions, reserved, xhi_addr;
    } PM_DESCRIPTOR;

/* Low-level dpmi interface */
BOOL dpmiVersion (WORD *wFlags, WORD *wMajorVer, WORD *wMinorVer,
              WORD *wProcessor);
BOOL dpmiRMInt (WORD wIntNum, WORD wFlags, RM386_INT far *rmInt,
                WORD wStackVals);
SELECTOR dpmiAllocNewSelector (void);
BOOL dpmiSetDescriptor (SELECTOR slSelector, PM_DESCRIPTOR far *pmDescriptor);
BOOL dpmiReadDescriptor (SELECTOR slSelector, PM_DESCRIPTOR far *pmDescriptor);
BOOL dpmiFreeSelector (SELECTOR slSelector);

/* High level dpmi */
BOOL dpmiSegmentToSelector (SEGMENT sgSegment, DWORD dwBytes,
                            SELECTOR *slSelector);
void vSetRMDescriptorAddr (SEGMENT sgSeg, PM_DESCRIPTOR *pmdD);

DWORD FAR PASCAL GlobalDosAlloc (DWORD);
WORD  FAR PASCAL  GlobalDosFree  (SELECTOR);
