;Request header definitions
;
;
rhstruc         STRUC                   ;13 byte common header
rh_len          db  ?                   ;length of request header
rh_unit         db  ?                   ;used in block mode only (unit number)
rh_command      db  ?                   ;command code
rh_status       dw  ?                   ;status
                db  8 dup (?)           ;reserved
rhstruc         ENDS

instruc         STRUC                   ;
                db 13 dup (?)           ;space for common header
in_unit         db  ?                   ;number units (block mode)
in_endaddr      dd  ?                   ;end address of resident code
in_bpbaptr      dd  ?                   ;points to bpb array (block mode)
in_driveno      db  ?                   ;drive number
instruc         ENDS

mcstruc         STRUC                   ;
                db 13 dup (?)           ;space for common header
mc_media        db  ?                   ;media descriptor byte from DOS
mc_retcode      db  ?                   ;return code
                                        ;  -1 media changed
                                        ;   0 dont know
                                        ;   1 media not changed
mc_volid        dd  ?                   ;points to previous volume ID
mcstruc         ENDS

bpstruc         STRUC                   ;
                db 13 dup (?)           ;space for common header
bp_media        db  ?                   ;media descriptor byte (DOS)
bp_bufptr       dd  ?                   ;pointer to buffer
bp_bpbaptr      dd  ?                   ;points to bpb
bpstruc         ENDS

;  For functions 03, 04, 08, 09, 12: Input/Output
iostruc         STRUC                   ;
                db 13 dup (?)           ;space for common header
io_media        db  ?                   ;media descriptor byte (DOS)
io_bufptr       dd  ?                   ;pointer to transfer buffer
io_count        dw  ?                   ;count of bytes/sectors transferred
io_sector       dw  ?                   ;start sector no (block mode)
io_volid        dd  ?                   ;pointer to vol. ID
iostruc         ENDS

ndstruc         STRUC                   ;
                db 13 dup (?)           ;space for common header
nd_read         db  ?                   ;byte read
ndstruc         ENDS

gestruc         STRUC                   ;
                db 13 dup (?)           ;space for common header
ge_major        db  ?                   ;major function
ge_minor        db  ?                   ;minor function
ge_si           dw  ?                   ;contents of register si
ge_di           dw  ?                   ;contents of register di
ge_reqptr       dd  ?                   ;pointer to request packet
gestruc         ENDS

rheader         EQU  es:[di]            ;points to the request header
lastcmd         EQU  24                 ;last legal command

;bit interpretation of status field in common header
statrec         RECORD error:1, res:5, busy:1, done:1, ecode:8
                ;error - Error occured
                ;res   - reserved field
                ;busy  - device busy
                ;done  - process complete
                ;ecode - error code
