/* Interacts with the real-mode device driver */
#include <dos.h>
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <malloc.h>

char szAppString[]= "RMDRIVER: This string is from the application.";
union REGS inregs, outregs;
struct SREGS sregs;

main()
{
char far *lpTransferBuf;
unsigned hDriver;
char szMessage[100];
int i;

    //Allocate the transfer buffer
    if ((lpTransferBuf = (char far *) _fmalloc (100))==NULL)
    {
        printf ("RMAPP: Error allocating buffer\n");
        exit (1);
    } //End if (could not allocate transfer buf)

    //Get a handle to the device driver
    if (_dos_open ("RMDRIVER", O_RDWR, &hDriver)!=0)
    {
        printf ("RMAPP: Error %d opening driver (%d)\n", errno, ENOENT);
        exit (1);
    } //End if (error opening driver)
    //Set raw io mode
    rmiSetRawMode (hDriver);

    fflush (stdin);
    printf ("Press  <Enter> to read from driver\n");
    while (!kbhit());
    getchar();

    //Read from device driver
    inregs.x.ax = 0x3F00;      //Read from device
    inregs.x.bx = hDriver;     //handle to the driver
    inregs.x.cx = 100;         //maximum bytes to read
    sregs.ds =    FP_SEG (lpTransferBuf);       //segment of transfer buffer
    inregs.x.dx = FP_OFF (lpTransferBuf);       //offset of transfer buffer
    printf ("RMAPP: Buffer segment:offset - %Fp\n", lpTransferBuf);
    intdosx (&inregs, &outregs, &sregs);

    // Print the buffer;  it now contains data from the device
    //driver.
    i=0;
    while (szMessage[i]= lpTransferBuf[i]) i++;
    printf ("%s\n", szMessage);

    fflush (stdin);
    printf ("Press  <Enter> to write to driver\n");
    while (!kbhit());
    getchar();

    // Write string to device driver
    i=0;
    while (lpTransferBuf[i++]= szAppString[i]);
    inregs.x.ax = 0x4000;      //Write to device
    inregs.x.bx = hDriver;     //Handle to driver
    inregs.x.cx = 100;         //Bytes to write
    sregs.ds =    FP_SEG (lpTransferBuf);   //segment of transfer buffer
    inregs.x.dx = FP_OFF (lpTransferBuf);   //offset of transfer buffer
    printf ("RMAPP: Buffer segment:offset - %Fp\n", lpTransferBuf);
    intdosx (&inregs, &outregs, &sregs);

    if (lpTransferBuf) _ffree (lpTransferBuf);

    //Close the device driver
    if (_dos_close (hDriver)!=0)
    {
        printf ("RMAPP: Error %d closing driver (%d)\n", errno, ENOENT);
        exit (1);
    } //End if (error closing driver)

    fflush (stdin);
    printf ("Press  <Enter> to attempt INT 6Bh\n");
    while (!kbhit());
    getchar();

    inregs.x.ax =  0x1001;
    inregs.x.bx =  0x1001;
    inregs.x.cx =  0x1001;
    inregs.x.dx =  0x1001;
    inregs.x.si =  0x1001;
    inregs.x.di =  0x1001;
    sregs.ds =     FP_SEG(lpTransferBuf);
    sregs.es =     FP_SEG(lpTransferBuf);
    printf ("RMAPP: Registers\n");
    printf ("\tRMAPP: AX, BX, CX, DX: %x, %x, %x, %x\n", inregs.x.ax,
             inregs.x.bx, inregs.x.cx, inregs.x.dx);
    printf ("\tRMAPP: SI, DI: %x, %x\n", inregs.x.si, inregs.x.di);
    printf ("\tRMAPP: DS, ES: %x, %x\n", sregs.ds, sregs.es);
    int86x (0x6b, &inregs, &outregs, &sregs);

} //End function (main)
/****************************************************************************

    FUNCTION:  rmiSetRawMode

    PURPOSE:  Places the device driver in raw (binary) mode

    COMMENTS:


****************************************************************************/
int rmiSetRawMode(unsigned hDriver)
{
    // Set the dd to raw mode - get, then set device control bits
    //bx - file handle for the driver
    //ax - 0x4400  Function for IOCTL call to read device control bits
    inregs.x.bx = hDriver;
    inregs.x.ax = 0x4400;
    intdos (&inregs, &outregs);
    // Now set raw mode bit of the device control bits
    //dl - bit 0x20 is set to indicate DOS should use raw mode with this
    //     device.  All other bits are unchanged.
    //ax - 0x4401   IOCTL function to set device bits
    inregs.x.bx = hDriver;
    inregs.h.dh=0;
    inregs.h.dl= outregs.h.dl | 0x20;
    inregs.x.ax = 0x4401;
    intdos (&inregs, &outregs);

    return 0;
} //End function (rmiSetRawMode)

