/****************************************************************************\
*                                                                            *
* HELPER.EXE - Windows DDE Server                                            *
*                                                                            *
* Written by Guy Eddon, 1992                                                 *
*                                                                            *
* HELPER.EXE WinExecs SERVER.EXE - Requires VDDED.386 and SERVER.EXE         *
*                                                                            *
* Build with MS C/C++ 7.00 or MS C 6.00 and the MS Windows 3.1 SDK:          *
*                                                                            *
*    cl -c -AM -G2sw -Zp -W3 -Os helper.c                                    *
*    link /NOD /NOE helper,,NUL,libw mlibcew oldnames,helper.def;            *
*    rc helper.rc                                                            *
*                                                                            *
\****************************************************************************/

#include <WINDOWS.H>
#include <DDE.H>
#include <STRING.H>
#include <STDLIB.H>
#include "helper.h"

#define VDDED_Dev_ID 305Fh

void far *Apientry;
static int xDelta;
static int yDelta;

char far temp_vxd_buffer[50] = { 0 };

long FAR PASCAL MainWndProc(HWND, UINT, WPARAM, LPARAM);
BOOL InitApplication(HANDLE);
BOOL InitInstance(HANDLE, int);
void MaybeAdviseData(int);

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
   {
   MSG msg;
   int i = 0;

   if(hPrevInstance)
      {
      MessageBox(NULL, "HELPER.EXE is already running,", NULL, MB_OK);
      exit(0);
      }

   WinExec("SERVER.EXE", SW_SHOWNORMAL);

	if(!InitApplication(hInstance))
	   return (FALSE);
   if(!InitInstance(hInstance, nCmdShow))
      return (FALSE);

   StartTalkToVirtualDevice();

   while(1)
      {
      if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
         {
         if(msg.message == WM_QUIT)
            break;
         TranslateMessage(&msg);
         DispatchMessage(&msg);
         }
      else
         {
         int data_test;
         TalkToVirtualDevice(TEST_DOS, 0);
         _asm mov data_test,ax
         if(data_test == EXIT_DOS)
            {
            if(i++ == 10000)
               {
               TalkToVirtualDevice(WINDOWS_NOTIFY_QUIT, 0);
               goto OUTAHERE;
               }
            }
         if(data_test == TRUE)
            {   
            MaybeAdviseData(1);
            TalkToVirtualDevice(CLEAR_DOS, 0);
            }
         }
      }

OUTAHERE:
   return (msg.wParam);
   }

BOOL InitApplication(HANDLE hInstance)
   {
   WNDCLASS  wc;
   nDoc = 1;
   wc.style = NULL;
   wc.lpfnWndProc = MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon(hInstance, "HELPER");
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW+1;
   wc.lpszMenuName = NULL;
   wc.lpszClassName = "HelperClass";
   if(!RegisterClass(&wc))
	   return (FALSE);
   wc.style = NULL;
   wc.lpfnWndProc = DDEWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = NULL;
   wc.hCursor = NULL;
   wc.hbrBackground = NULL;
   wc.lpszMenuName =  NULL;
   wc.lpszClassName = "ServerDDEWndClass";
   return (RegisterClass(&wc));
   }

/*
   Saves instance handle, creates main window, and creates 3 child edit
      controls with id's 1, 2, and 3.
*/
BOOL InitInstance(HANDLE hInstance, int nCmdShow)
   {
   char szCaption[20];
   HDC hDC;
   TEXTMETRIC tm;
   int nHorzRes, nVertRes;
   InitAckTimeOut();
   hInst = hInstance;
   strcpy(szDocName, "");
   strcpy(szCaption, "SERVER");
   strcat(szCaption, szDocName);
   hwndMain = CreateWindow("HelperClass", szCaption, WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance, NULL);
   if(!hwndMain)
      return (FALSE);
   hDC = GetDC(hwndMain);
   GetTextMetrics(hDC, (LPTEXTMETRIC)&tm);
   xDelta = tm.tmAveCharWidth;
   yDelta = tm.tmHeight + tm.tmExternalLeading;
   nHorzRes = GetDeviceCaps(hDC, HORZRES);
   nVertRes = GetDeviceCaps(hDC, VERTRES);
   ReleaseDC(hwndMain, hDC);
   if(!(cfLink = RegisterClipboardFormat("Link")))
	   return (FALSE);
   ShowWindow(hwndMain, SW_SHOWMINNOACTIVE);

/*   ShowWindow(hwndMain, SW_HIDE); */

   UpdateWindow(hwndMain);
   return (TRUE);
   }

long FAR PASCAL MainWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
   {
   HDC hDC;
   PAINTSTRUCT ps;
   switch(message)
      {
      case WM_PAINT:
	      hDC = BeginPaint(hwnd, &ps);
	      EndPaint(hwnd, &ps);
         break;
      case WM_QUERYOPEN:
         return 0;
      case WM_DDE_INITIATE:
         ServerInitiate((HWND)wParam, lParam);
         break;
      case WM_CLOSE:
         return 0;
      case WM_DESTROY:
     	   TerminateConversations();
         PostQuitMessage(0);
         break;
      default:
         return (DefWindowProc(hwnd, message, wParam, lParam));
      }
   return (0L);
   }

/* Send data to all clients for which a hot or warm link
	      has been established for the specified item.    */
void MaybeAdviseData(int nItem)
   {
   HWND hwndServerDDE;
   char szItemName[ITEM_NAME_MAX_SIZE+1];
   char szItemValue[ITEM_VALUE_MAX_SIZE+1];
   BOOL bDeferUpdate;
   BOOL bAckRequest;
   hwndServerDDE = NULL;
   while(1)
	   if(hwndServerDDE = GetNextAdvise(hwndServerDDE, nItem))
         {
	      GetAdviseData(hwndServerDDE, nItem, szItemName, szItemValue, &bDeferUpdate, &bAckRequest);
         SendData(hwndServerDDE, GetHwndClientDDE(hwndServerDDE), szItemName, szItemValue, bDeferUpdate, bAckRequest, FALSE);
         }
      else
         return;
   }

void StartTalkToVirtualDevice(void)
   {
   _asm
      {
      mov     ax,1684h                ; Get Device API call
      mov     bx,VDDED_Dev_ID          ; for the VDDED VxD
      int     2fh                     ; do enhanced api
      mov     ax,es                   ; is VDDED installed?
      or      ax,di
      jz      Error1                  ; if not, split
      mov     WORD PTR Apientry,di    ; save the callback address
      mov     WORD PTR Apientry+2,es
      mov     bx, seg temp_vxd_buffer
      mov     cx, offset temp_vxd_buffer
      mov     ax, WINDOWS_CHECK
      call    DWORD PTR Apientry      ; call VDDED
      }
   return;

Error1:
   MessageBox(NULL, "VDDED.386 is not running.", NULL, MB_OK);
   exit(0);
   }

void TalkToVirtualDevice(int WM_DDE_type, int SendReceive)
   {
   _asm
      {
      mov     ax,WM_DDE_type
      mov     bx,SendReceive
      call    DWORD PTR Apientry      ; call VDDED
      }
   }

/****************************************************************************/

typedef struct CONV
   {
   HWND hwndServerDDE;
   HWND hwndClientDDE;
   BOOL bInClientRequestedTerminate;
   };
typedef struct ADVISE
   {
   HANDLE hData;
   HWND hwndServerDDE;
   HWND hwndClientDDE;
   ATOM atomItem;
   BOOL bAckRequest;
   BOOL bDeferUpdate;
   BOOL bAwaitingAck;
   int nItem;
   };

struct CONV Conv[CONV_MAX_COUNT];
static int nConvCount = 0;
static struct ADVISE Advise[ADVISE_MAX_COUNT];
static int nAdviseCount = 0;
struct ADVISE * NEAR FindAdvise(HWND, int);
struct CONV *	NEAR FindConv(HWND);

/* Register a new hot or warm link to a specified client,
      for a specified server application item (1, 2, or 3). */
BOOL AddAdvise(HWND hwndServerDDE, HANDLE hDDEAdviseOptions, ATOM atomItem, int nItem)
   {
   struct ADVISE * pAdvise;
   DDEADVISE FAR * lpDDEAdviseOptions;
   int nAdviseIndex;
   if(nAdviseCount >= ADVISE_MAX_COUNT)
      {
      MessageBox(hwndMain, "Maximum advisories exceeded", "Helper", MB_ICONEXCLAMATION | MB_OK);
      return (FALSE);
      }
   if((lpDDEAdviseOptions = (DDEADVISE FAR *)GlobalLock(hDDEAdviseOptions)) == NULL)
      return (FALSE);
   for(pAdvise = Advise, nAdviseIndex = 0; nAdviseIndex < nAdviseCount; pAdvise++, nAdviseIndex++)
   	if(pAdvise->hwndServerDDE == hwndServerDDE && pAdvise->nItem == nItem)
   	   {
	      MessageBox(hwndMain, "Advisory (paste link) already established", "Helper", MB_ICONEXCLAMATION | MB_OK);
   	   GlobalUnlock(hDDEAdviseOptions);
	      return (FALSE);
      	}
   pAdvise = Advise + nAdviseCount++;
   pAdvise->hwndServerDDE = hwndServerDDE;
   pAdvise->hwndClientDDE = GetHwndClientDDE(hwndServerDDE);
   pAdvise->nItem = nItem;
   pAdvise->atomItem = atomItem;
   pAdvise->bAckRequest = lpDDEAdviseOptions->fAckReq;
   pAdvise->bDeferUpdate = lpDDEAdviseOptions->fDeferUpd;
   pAdvise->bAwaitingAck = FALSE;
   GlobalUnlock(hDDEAdviseOptions);
   return (TRUE);
   }

/* Register a new conversation with a client window */
BOOL AddConv(HWND hwndServerDDE, HWND hwndClientDDE)
   {
   struct CONV * pConv;
   if(nConvCount >= CONV_MAX_COUNT)
      return (FALSE);
   if(FindConv(hwndServerDDE) != NULL)
      return (FALSE); /* conversation already added */
   pConv = Conv + nConvCount++;
   pConv->hwndServerDDE = hwndServerDDE;
   pConv->hwndClientDDE = hwndClientDDE;
   pConv->bInClientRequestedTerminate = FALSE;
   return (TRUE);
   }

/* Used during termination of application, to
      determine whether any conversations are still active
	   while the conversations are being terminated.        */
BOOL AtLeastOneConvActive()
   {
   return (nConvCount? TRUE: FALSE);
   }

/* Set Awaiting Ack state to true for specified item. */
void CheckOutSentData(HWND hwndServerDDE, int nItem, ATOM atomItem, HANDLE hData)
   {
   struct ADVISE * pAdvise;
   if(!(pAdvise = FindAdvise(hwndServerDDE, nItem)))
      return;
   pAdvise->bAwaitingAck = TRUE;
   pAdvise->atomItem = atomItem;
   pAdvise->hData = hData;
   return;
   }

/* Find advisory data for a specific conversation item. */
struct ADVISE * NEAR FindAdvise(HWND hwndServerDDE, int nItem)
   {
   struct ADVISE * pAdvise;
   int nAdviseIndex;

   for(nAdviseIndex = 0, pAdvise = Advise; nAdviseIndex < nAdviseCount; nAdviseIndex++, pAdvise++)
      {
	   if(pAdvise->hwndServerDDE == hwndServerDDE && pAdvise->nItem == nItem)
         {
         return (pAdvise);
         }
      }
   return (NULL);
   }

/* Find the conversation for a specified server DDE window. */
struct CONV * NEAR FindConv(HWND hwndServerDDE)
   {
   struct CONV * pConv;
   int nConvIndex;

   for(nConvIndex = 0, pConv = Conv; nConvIndex < nConvCount; nConvIndex++, pConv++)
      {
  	   if(pConv->hwndServerDDE == hwndServerDDE)
         return (pConv);
      }
   return (NULL);
   }

/* Get advisory data for a specified conversation item. */
BOOL GetAdviseData(HWND hwndServerDDE, int nItem, char *szItemName, char *szItemValue, BOOL *pbDeferUpdate, BOOL *pbAckRequest)
   {
   struct ADVISE *pAdvise;
   if(!(pAdvise = FindAdvise(hwndServerDDE, nItem)))
      return (FALSE);
   strcpy(szItemName, "AMOUNT");
   *pbDeferUpdate = pAdvise->bDeferUpdate;
   *pbAckRequest = pAdvise->bAckRequest;
   TalkToVirtualDevice(VDDED_DATA, RECEIVE);
   Copy_From_Temp_Buffer(szItemValue);
   return (TRUE);
   }

void Copy_From_Temp_Buffer(char *string)
   {
   lstrcpy(string, temp_vxd_buffer);
   }

void Copy_To_Temp_Buffer(char *string)
   {
   lstrcpy(temp_vxd_buffer, string);
   }

/* Get the hwnd of the client in conversation with a specified
	      server DDE window.                                    */
HWND GetHwndClientDDE(HWND hwndServerDDE)
   {
   struct CONV * pConv;

   if(!(pConv = FindConv(hwndServerDDE)))
	   return (NULL);
   return (pConv->hwndClientDDE);
   }

/* Find a client that needs to be notified that a value of
	      a specified item (a hot or warm link item) has changed.
	      Since a hot or warm link to the item may have been established
	      for multiple conversations (multiple clients), this function
	      is set up to step through the list of such conversations.
	      Start the list by passing a NULL hwndClientDDE.  To get the
	      next conversation in the list, pass the previous client returned
	      by this function.                                                */
HWND GetNextAdvise(HWND hwndServerDDE, int nItem)
   {
   struct ADVISE * pAdvise;
   int nAdviseIndex;
   if(hwndServerDDE)
      {
      for(nAdviseIndex = 0, pAdvise = Advise; nAdviseIndex < nAdviseCount; nAdviseIndex++, pAdvise++)
	      if(pAdvise->hwndServerDDE == hwndServerDDE && pAdvise->nItem == nItem)
            {
            pAdvise++;
            break;
            }
      if(nAdviseIndex >= nAdviseCount)
         return (NULL);
      }
   else
      {
      pAdvise = Advise;
      nAdviseIndex = 0;
      }
   for(; nAdviseIndex < nAdviseCount; nAdviseIndex++, pAdvise++)
      if(pAdvise->nItem == nItem)
	      return (pAdvise->hwndServerDDE);
   return (NULL);
   }

/* Get next client in list of conversations.  To get the
	      first hwndServerDDE in the conversation list, pass in a NULL
	      value for hwndServerDDE.                                     */
HWND GetNextConv(HWND hwndServerDDE)
   {
   struct CONV * pConv;
   int nConvIndex;
   if(hwndServerDDE)
      {
	   for(nConvIndex = 0, pConv = Conv; nConvIndex < nConvCount; nConvIndex++, pConv++)
	      if(pConv->hwndServerDDE == hwndServerDDE)
       		if(++nConvIndex < nConvCount)
		         return (++pConv)->hwndServerDDE;
            else
               return (NULL);
      return (NULL);
      }
   if(nConvCount > 0)
	   return (Conv[0].hwndServerDDE);
   else
      return (NULL);
   }

/* A global memory object (hData) was sent in a WM_DDE_DATA
	      message, but the client never used it.  So, the server is
	      responsible for freeing the object.                       */
void GlobalFreeSentData(HWND hwndServerDDE, int nItem)
   {
   struct ADVISE * pAdvise;
   if(!(pAdvise = FindAdvise(hwndServerDDE, nItem)))
      return;
   pAdvise->bAwaitingAck = FALSE;
   GlobalDeleteAtom(pAdvise->atomItem);
   GlobalFree(pAdvise->hData);
   return;
   }

/* Terminate whether conversation with specified client is
	      in process of being terminated.                   */
BOOL IsConvInTerminateState(HWND hwndServerDDE)
   {
   struct CONV * pConv;
   if(pConv = FindConv(hwndServerDDE))
	   return (pConv->bInClientRequestedTerminate);
   else
      return (FALSE);
   }

/* Cancel a hot or warm link for a specified conversation item.
	      If a 0 value is specified for nItem, then all hot/warm links
              for the specified client are removed.                   */
BOOL RemoveAdvise(HWND hwndServerDDE, int nItem)
   {
   struct ADVISE * pAdvise;
   int nAdviseIndex;
   int nRemoveCount;
   nRemoveCount = 0;
   for(nAdviseIndex = 0, pAdvise = Advise; nAdviseIndex < nAdviseCount; nAdviseIndex++, pAdvise++)
      {
      if(nRemoveCount)
         *(pAdvise-nRemoveCount) = *pAdvise;
	   if(pAdvise->hwndServerDDE == hwndServerDDE && (!nItem || pAdvise->nItem == nItem))
         nRemoveCount++;
      }
   if(nRemoveCount)
      {
      nAdviseCount -= nRemoveCount;
      return (TRUE);
      }
   else
      return (FALSE);
   }

/* Remove conversation from conversation list, and remove
	      all hot/warm links associated with that conversation
	      from the advisory list.                              */
void RemoveConv(HWND hwndServerDDE)
   {
   struct CONV * pConv;
   int nConvIndex;
   struct ADVISE * pAdvise;
   struct ADVISE * pAdviseShift;
   int nAdviseIndex;
   int nAdviseDecrement;
   for(nConvIndex = 0, pConv = Conv; nConvIndex < nConvCount; nConvIndex++, pConv++)
	   if(pConv->hwndServerDDE == hwndServerDDE)
         break;
   nConvCount--;
   while (nConvIndex < nConvCount)
      {
   	*pConv = *(pConv+1);
	   nConvIndex++;
   	pConv++;
      }
   /* Remove each hot/warm link */
   pAdviseShift = Advise;
   nAdviseDecrement = 0;
   for(nAdviseIndex = 0, pAdvise = Advise; nAdviseIndex < nAdviseCount; nAdviseIndex++, pAdvise++)
      {
	   if(pAdvise->hwndServerDDE == hwndServerDDE)
         {
         nAdviseDecrement++;
         if(pAdvise->bAwaitingAck)
            {
            /* Destroy objects perhaps not destroyed by client */
       		GlobalDeleteAtom(pAdvise->atomItem);
            GlobalFree(pAdvise->hData);
            }
         }
      else
         *(pAdviseShift++) = *pAdvise;
      }
   nAdviseCount -= nAdviseDecrement;
   return;
   }

/* Set conversations's terminate state to TRUE. */
void SetConvInTerminateState(HWND hwndServerDDE)
   {
   struct CONV * pConv;
   if(pConv = FindConv(hwndServerDDE))
      pConv->bInClientRequestedTerminate = TRUE;
   return;
   }

/****************************************************************************/

#define DEFAULT_ACK_TIME_OUT_MILLISEC 10000

static int nAckTimeOut;
static BOOL bTerminating = FALSE;
int  NEAR GetDocIndexGivenName(char *);
int  NEAR GetItemNumber(char *);
void MaybeAdviseData(int nItem);

/* Handles all DDE messages received by the server application. */
long FAR PASCAL DDEWndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
   {
   switch(message)
      {
      case WM_DDE_ACK:
         ServerAcknowledge(hwnd, (HWND)wParam, lParam);
	      return (0L);
   	case WM_TIMER:
	      ServerAcknowledge(hwnd, (HWND)wParam, 0L);
	      return (0L);
      case WM_DDE_ADVISE:
         ServerAdvise(hwnd, (HWND)wParam, lParam);
	      return (0L);
      case WM_DDE_POKE:
         ServerPoke(hwnd, (HWND)wParam, lParam);
	      return (0L);
      case WM_DDE_TERMINATE:
         ServerTerminate(hwnd, (HWND)wParam);
	      return (0L);
      case WM_DDE_UNADVISE:
         ServerUnadvise(hwnd, (HWND)wParam, lParam);
	      return (0L);
      case WM_DDE_REQUEST:
         ServerRequest(hwnd, (HWND)wParam, lParam);
	      return (0L);
   	case WM_DDE_EXECUTE:
	      ServerExecute(hwnd, (HWND)wParam, (HANDLE)HIWORD(lParam));
	      return (0L);
   	default:
	      return (DefWindowProc(hwnd, message, wParam, lParam));
      }
   }

/* Get server control i.d. (1, 2, or 3) given item name. */
int NEAR GetItemNumber(char *szItem)
   {
   int nItem;
   if(!strcmpi(szItem, "AMOUNT"))
      nItem = 1;
   else
      nItem = 0;
   return (nItem);
   }

/* Get DDE timeout value from win.ini.  Value is in milliseconds. */
void InitAckTimeOut(void)
   {
   /* Finds value in win.ini section corresponding to application name */
   nAckTimeOut = GetPrivateProfileInt("Helper", "DdeTimeOut", DEFAULT_ACK_TIME_OUT_MILLISEC, "helper.ini");
   return;
   }

/* Send data to client. */
void SendData(HWND hwndServerDDE, HWND hwndClientDDE, char *szItemName, char *szItemValue, BOOL bDeferUpdate, BOOL bAckRequest, BOOL bRequestData)
   {
   ATOM atomItem;
   HANDLE hData;
   DDEDATA FAR * lpData;
   int nItem;

   if(bDeferUpdate)
      {
      atomItem = GlobalAddAtom((LPSTR)szItemName);
      TalkToVirtualDevice(WM_DDE_DATA, SEND);
		if(!PostMessage(hwndClientDDE, WM_DDE_DATA, hwndServerDDE, MAKELONG(0, atomItem)))
  	      GlobalDeleteAtom(atomItem);
      return;
      }
   if(!(hData = GlobalAlloc(GMEM_MOVEABLE | GMEM_DDESHARE, (LONG)sizeof(DDEDATA) +lstrlen(szItemValue) + 2)))
      return;
   if(!(lpData = (DDEDATA FAR*)GlobalLock(hData)))
      {
   	GlobalFree(hData);
      return;
      }
   lpData->fAckReq = bAckRequest;
   lpData->cfFormat = CF_TEXT;
   lpData->fResponse = bRequestData;
   lpData->fRelease = TRUE;
   lstrcpy((LPSTR)lpData->Value, (LPSTR)szItemValue);
   lstrcat((LPSTR)lpData->Value, (LPSTR)"\r\n");
   GlobalUnlock(hData);
   atomItem = GlobalAddAtom((LPSTR)szItemName);
   TalkToVirtualDevice(WM_DDE_DATA, SEND);
   if(!PostMessage(hwndClientDDE, WM_DDE_DATA, hwndServerDDE, MAKELONG(hData, atomItem)))
      {
      GlobalFree(hData);
      GlobalDeleteAtom(atomItem);
   	return;
      }
   if(bAckRequest)
      {
	   SetTimer(hwndServerDDE, hwndClientDDE, nAckTimeOut, NULL);
	   nItem = GetItemNumber(szItemName);
    	CheckOutSentData(hwndServerDDE, nItem, atomItem, hData);
      }
   return;
   }

/* Post terminate message and indicate that conversation is
	      in process ot being terminated.                    */
void SendTerminate(HWND hwndServerDDE, HWND hwndClientDDE)
   {
   SetConvInTerminateState(hwndServerDDE);
   TalkToVirtualDevice(WM_DDE_TERMINATE, SEND);
   PostMessage(hwndClientDDE, WM_DDE_TERMINATE, hwndServerDDE, 0L);
   return;
   }

/* Called when server application receives ACK or NACK, or
	      when server receives time out waiting for response to WM_DDE_DATA */
void ServerAcknowledge(HWND hwndServerDDE, HWND hwndClientDDE, LONG lParam)
   {
   char szItemName[ITEM_NAME_MAX_SIZE+1];
   int nItem;
   TalkToVirtualDevice(WM_DDE_ACK, RECEIVE);
   KillTimer(hwndServerDDE, hwndClientDDE);
   if(!(LOWORD(lParam) & 0x8000))
      {
      GlobalGetAtomName(HIWORD(lParam), szItemName, ITEM_NAME_MAX_SIZE);
      nItem = GetItemNumber(szItemName);
	   GlobalFreeSentData(hwndServerDDE, nItem);
	   MessageBox(hwndMain, "DDE send data failed", "Helper", MB_ICONEXCLAMATION | MB_OK);
      }
   if(HIWORD(lParam))
   	GlobalDeleteAtom(HIWORD(lParam));
   return;
   }

/* Called when server application receives WM_DDE_ADVISE message. */
void ServerAdvise(HWND hwndServerDDE, HWND hwndClientDDE, LONG lParam)
   {
   HANDLE hDDEAdviseOptions;
   ATOM atomItem;
   char szItem[ITEM_NAME_MAX_SIZE+1];
   int nItem;
   TalkToVirtualDevice(WM_DDE_ADVISE, RECEIVE);
   hDDEAdviseOptions = LOWORD(lParam);
   atomItem = HIWORD(lParam);
   GlobalGetAtomName(atomItem, szItem, ITEM_NAME_MAX_SIZE);
   if(!(nItem = GetItemNumber(szItem))	|| !AddAdvise(hwndServerDDE, hDDEAdviseOptions, atomItem, nItem))
      {
      TalkToVirtualDevice(WM_DDE_ACK, SEND);
	   PostMessage(hwndClientDDE, WM_DDE_ACK, hwndServerDDE, MAKELONG(0, atomItem));
      return;
      }
   TalkToVirtualDevice(WM_DDE_ACK, SEND);
   PostMessage(hwndClientDDE, WM_DDE_ACK,	hwndServerDDE, MAKELONG(0x8000, atomItem));
   GlobalFree(hDDEAdviseOptions);
   return;
   }

/* Called when server application receives WM_DDE_EXECUTE message. */
void ServerExecute(HWND hwndServerDDE, HWND hwndClientDDE, HANDLE hCommand)
   {
   LPSTR lpstrCommand;
   char szExecuteString[EXECUTE_STRING_MAX_SIZE+1];
   TalkToVirtualDevice(WM_DDE_EXECUTE, RECEIVE);
   if(!(lpstrCommand = GlobalLock(hCommand)))
      {
      TalkToVirtualDevice(WM_DDE_ACK, SEND);
   	PostMessage(hwndClientDDE, WM_DDE_ACK, hwndServerDDE, MAKELONG(0, hCommand));
      return;
      }
   if(lstrlen(lpstrCommand) > EXECUTE_STRING_MAX_SIZE)
   	lpstrCommand[EXECUTE_STRING_MAX_SIZE] = 0;
   lstrcpy(szExecuteString, lpstrCommand);
   GlobalUnlock(hCommand);
   TalkToVirtualDevice(WM_DDE_ACK, SEND);
   PostMessage(hwndClientDDE,	WM_DDE_ACK,	hwndServerDDE,	MAKELONG(0x8000, hCommand));
   Copy_To_Temp_Buffer(szExecuteString);
   {int i;for(i=0;i<32000;i++);}
   TalkToVirtualDevice(VDDED_EXECUTE, SEND);
   return;
   }

/* Called when server application receives WM_DDE_INITIATE message. */
void ServerInitiate(HWND hwndClientDDE, LONG lParam)
   {
   HWND hwndServerDDE;
   ATOM atomApplicationRcvd;
   ATOM atomTopicRcvd;
   ATOM atomApplicationReturn;
   ATOM atomTopicReturn;
   char szApplication[APP_MAX_SIZE+1];
   char szTopic[TOPIC_MAX_SIZE+1];
   TalkToVirtualDevice(WM_DDE_INITIATE, RECEIVE);
   if(!(hwndServerDDE = CreateWindow("ServerDDEWndClass", "ServerDDE", WS_CHILD,	/* not visible */ 0, 0, 0, 0, /* no position or dimensions */ hwndMain,	/* parent */ NULL, /* no menu */ hInst, NULL)))
	   return;
   if(atomApplicationRcvd = LOWORD(lParam))
      GlobalGetAtomName(atomApplicationRcvd, szApplication, APP_MAX_SIZE);
   if(atomApplicationRcvd && strcmpi(szApplication, "SERVER"))
      return;
   if(atomTopicRcvd = HIWORD(lParam))
      {
      GlobalGetAtomName(atomTopicRcvd, szTopic, TOPIC_MAX_SIZE);
      if(strcmpi(szTopic, szDocName))
         return;
      }
   if(AddConv(hwndServerDDE, hwndClientDDE))
      {
      atomApplicationReturn = GlobalAddAtom("SERVER");
      atomTopicReturn = GlobalAddAtom(szDocName);
   	SendMessage(hwndClientDDE, WM_DDE_ACK,	hwndServerDDE, MAKELONG(atomApplicationReturn, atomTopicReturn));
      TalkToVirtualDevice(WM_DDE_ACK, SEND);
      }
   return;
   }

/* Called when server application receives WM_DDE_POKE message. */
void ServerPoke(HWND hwndServerDDE, HWND hwndClientDDE, LONG lParam)
   {
   HANDLE hPokeData;
   DDEPOKE FAR *lpPokeData;
   ATOM atomItem;
   int nItem;
   char szItemName[ITEM_NAME_MAX_SIZE+1];
   char szItemValue[ITEM_VALUE_MAX_SIZE+1];
   BOOL bRelease;
   char *pcCarriageReturn;
   TalkToVirtualDevice(WM_DDE_POKE, RECEIVE);
   hPokeData = LOWORD(lParam);
   atomItem = HIWORD(lParam);
   GlobalGetAtomName(atomItem, szItemName, ITEM_NAME_MAX_SIZE);
   if(!(lpPokeData = (DDEPOKE FAR *)GlobalLock(hPokeData)) || lpPokeData->cfFormat != CF_TEXT || !(nItem = GetItemNumber(szItemName)))
      {
      TalkToVirtualDevice(WM_DDE_ACK, SEND);
	   PostMessage(hwndClientDDE, WM_DDE_ACK, hwndServerDDE, MAKELONG(0, atomItem));
   	return;
      }
   lstrcpy(szItemValue, lpPokeData->Value);
   if(pcCarriageReturn = strchr(szItemValue, '\r'))
      *pcCarriageReturn = 0;
   MaybeAdviseData(nItem);
   bRelease = lpPokeData->fRelease;
   GlobalUnlock(hPokeData);
   if(bRelease)
      GlobalFree(hPokeData);
   TalkToVirtualDevice(WM_DDE_ACK, SEND);
   PostMessage(hwndClientDDE,	WM_DDE_ACK,	hwndServerDDE,	MAKELONG(0x8000, atomItem));
   Copy_To_Temp_Buffer(szItemValue);
   {int i;for(i=0;i<32000;i++);}
   TalkToVirtualDevice(VDDED_POST, SEND);
   return;
   }

/* Called when server application receives WM_DDE_REQUEST message. */
void ServerRequest(HWND hwndServerDDE, HWND hwndClientDDE, LONG lParam)
   {
   char ClipboardBuffer[100], szItem[ITEM_NAME_MAX_SIZE+1];
   int nItem;
   GlobalGetAtomName(HIWORD(lParam), szItem, ITEM_NAME_MAX_SIZE);
   if(!(nItem = GetItemNumber(szItem))	|| (LOWORD(lParam) != CF_TEXT))
      {
      TalkToVirtualDevice(WM_DDE_ACK, SEND);
	   PostMessage(hwndClientDDE, WM_DDE_ACK, hwndServerDDE, MAKELONG(0, HIWORD(lParam)));
      return;
      }
   TalkToVirtualDevice(WM_DDE_REQUEST, RECEIVE);
   Copy_From_Temp_Buffer(ClipboardBuffer);
   SendData(hwndServerDDE, hwndClientDDE, szItem, ClipboardBuffer, FALSE, FALSE, TRUE);
   GlobalDeleteAtom(HIWORD(lParam));
   return;
   }

/* Called when server application receives WM_DDE_TERMINATE message. */
void ServerTerminate(HWND hwndServerDDE, HWND hwndClientDDE)
   {
   TalkToVirtualDevice(WM_DDE_TERMINATE, RECEIVE);
   if(!IsConvInTerminateState(hwndClientDDE))
      {
      TalkToVirtualDevice(WM_DDE_TERMINATE, SEND);
	   PostMessage(hwndClientDDE, WM_DDE_TERMINATE, hwndServerDDE, 0L);
      }
   RemoveConv(hwndServerDDE);
   DestroyWindow(hwndServerDDE);
   return;
   }

/* Called when server application receives WM_DDE_UNADIVSE message. */
void ServerUnadvise(HWND hwndServerDDE, HWND hwndClientDDE, LONG lParam)
   {
   char szItem[ITEM_NAME_MAX_SIZE+1];
   int nItem;
   BOOL bSuccess;
   TalkToVirtualDevice(WM_DDE_UNADVISE, RECEIVE);
   if(HIWORD(lParam))
      {
      GlobalGetAtomName(HIWORD(lParam), szItem, ITEM_NAME_MAX_SIZE);
      nItem = GetItemNumber(szItem);
   	bSuccess = RemoveAdvise(hwndServerDDE, nItem);
      }
   else
	   bSuccess = RemoveAdvise(hwndServerDDE, 0);
   if(bSuccess)
      {
      TalkToVirtualDevice(WM_DDE_ACK, SEND);
	   PostMessage(hwndClientDDE, WM_DDE_ACK, hwndServerDDE, MAKELONG(0x8000, HIWORD(lParam)));
      }
   else
      {
      TalkToVirtualDevice(WM_DDE_ACK, SEND);
	   PostMessage(hwndClientDDE, WM_DDE_ACK, hwndServerDDE, MAKELONG(0, HIWORD(lParam)));
      }
   return;
   }

/* Processes WM_DESTROY message, terminates all conversations. */
void TerminateConversations()
   {
   HWND hwndServerDDE;
   LONG lTimeOut;
   MSG msg;
   hwndServerDDE = NULL;
   while(hwndServerDDE = GetNextConv(hwndServerDDE))
   	SendTerminate(hwndServerDDE, GetHwndClientDDE(hwndServerDDE));
   lTimeOut = GetTickCount() + (LONG)nAckTimeOut;
   while(PeekMessage(&msg, NULL, WM_DDE_FIRST, WM_DDE_LAST, PM_REMOVE))
      {
      DispatchMessage(&msg);
   	if(msg.message == WM_DDE_TERMINATE)
	      if(!AtLeastOneConvActive())
		      break;
      if(GetTickCount() > (DWORD)lTimeOut)
         break;
      }
   return;
   }

