/****************************************************************************\
*                                                                            *
* Listing 1                                                                  *
*                                                                            *
* SERVER.EXE - DOS DDE Server                                                *
*                                                                            *
* Written by Guy Eddon, 1992                                                 *
*                                                                            *
* SERVER.EXE is WinExec by HELPER.EXE - Requires VDDED.386 and HELPER.EXE    *
*                                                                            *
* Build with MS C/C++ 7.00 or MS C 6.00 and the MS Windows 3.1 SDK:          *
*                                                                            *
*    cl /c /Gs /AL server.c                                                  *
*    link serverd,,NUL,,;                                                    *
*                                                                            *
\****************************************************************************/

#include <WINDOWS.H>                 /* Few DOS programs ever use WINDOWS.H */
#include <DDE.H>                     /* Few DOS programs ever use DDE.H     */
#include <DOS.H>
#include <BIOS.H>
#include <CONIO.H>
#include <STDIO.H>

#define MK_FP(seg,ofs) \
   ((void far *)(((unsigned long)(seg) << 16) | (unsigned)(ofs)))

#define REAL_MODE_CALLBACK 0x5555            /* Give VxD real mode address  */
#define UPDATE_DDE         0x7777            /* Server has data             */
#define VDDED_Dev_ID       0x305F            /* VDDED VxD ID                */
#define VID_NORMAL         0x07              /* Normal video attribute      */
#define VID_NORMAL_INT     0x0F              /* Intense video attribute     */
#define VID_REVERSE        0x70              /* Reverse vido attribute      */
#define ESC                27                /* ESC key                     */
#define VDDED_DATA         200               /* VDDED data request          */
#define VDDED_EXECUTE      201               /* VDDED execute request       */
#define VDDED_POST         202               /* VDDED poke request          */
#define DOS_NOTIFY_QUIT    0x0299            /* Server exit notify message  */
#define DOS_COPY_TO_VXD    0x1623
#define DOS_COPY_FROM_VXD  0x1624

int read_field(unsigned char, unsigned char, unsigned char, char *);
void clear(unsigned char, unsigned char, unsigned char, unsigned char,
   unsigned char);
void mxyputc(unsigned char, unsigned char, char, unsigned char,
   unsigned char);
void mxyputs(unsigned char, unsigned char, char far *, unsigned char);
void moutchar(unsigned char, unsigned char, char, unsigned char);
void box_double(unsigned char, unsigned char, unsigned char, unsigned char);
void gotoxy(unsigned char, unsigned char);
void create_screen(void);
unsigned keyboard(void);
void CopyToVxD(void);
void CopyFromVxD(void);

void far *Apientry = 0;
char far *vid_mem_one;
char far Buffer[50] = { 0 };

int initiate_receive,
    terminate_receive,
    advise_receive,
    unadvise_receive,
    ack_receive,
    data_receive,
    request_receive,
    poke_receive,
    execute_receive;

int initiate_send,
    terminate_send,
    advise_send,
    unadvise_send,
    ack_send,
    data_send,
    request_send,
    poke_send,
    execute_send;

void far DdeCallBack()
   {
   char string[10];
   int message, SendReceive;

   _asm mov message, ax
   _asm mov SendReceive, bx

   switch(message)
      {
      case WM_DDE_INITIATE:
         SendReceive ? initiate_receive++ : initiate_send++;
         itoa(initiate_receive, string, 10);
         mxyputs(50, 10, string, VID_NORMAL);
         itoa(initiate_send, string, 10);
         mxyputs(61, 10, string, VID_NORMAL);
         break;

      case WM_DDE_TERMINATE:
         SendReceive ? terminate_receive++ : terminate_send++;
         itoa(terminate_receive, string, 10);
         mxyputs(50, 11, string, VID_NORMAL);
         itoa(terminate_send, string, 10);
         mxyputs(61, 11, string, VID_NORMAL);
         break;

      case WM_DDE_ADVISE:
         SendReceive ? advise_receive++ : advise_send++;
         itoa(advise_receive, string, 10);
         mxyputs(50, 12, string, VID_NORMAL);
         itoa(advise_send, string, 10);
         mxyputs(61, 12, string, VID_NORMAL);
         break;

      case WM_DDE_UNADVISE:
         SendReceive ? unadvise_receive++ : unadvise_send++;
         itoa(unadvise_receive, string, 10);
         mxyputs(50, 13, string, VID_NORMAL);
         itoa(unadvise_send, string, 10);
         mxyputs(61, 13, string, VID_NORMAL);
         break;

      case WM_DDE_ACK:
         SendReceive ? ack_receive++ : ack_send++;
         itoa(ack_receive, string, 10);
         mxyputs(50, 14, string, VID_NORMAL);
         itoa(ack_send, string, 10);
         mxyputs(61, 14, string, VID_NORMAL);
         break;

      case WM_DDE_DATA:
         SendReceive ? data_receive++ : data_send++;
         itoa(data_receive, string, 10);
         mxyputs(50, 15, string, VID_NORMAL);
         itoa(data_send, string, 10);
         mxyputs(61, 15, string, VID_NORMAL);
         break;

      case WM_DDE_POKE:
         SendReceive ? poke_receive++ : poke_send++;
         itoa(poke_receive, string, 10);
         mxyputs(50, 17, string, VID_NORMAL);
         itoa(poke_send, string, 10);
         mxyputs(61, 17, string, VID_NORMAL);
         break;

      case WM_DDE_EXECUTE:
         SendReceive ? execute_receive++ : execute_send++;
         itoa(execute_receive, string, 10);
         mxyputs(50, 18, string, VID_NORMAL);
         itoa(execute_send, string, 10);
         mxyputs(61, 18, string, VID_NORMAL);
         break;

      case WM_DDE_REQUEST:
         SendReceive ? request_receive++ : request_send++;
         itoa(request_receive, string, 10);
         mxyputs(50, 16, string, VID_NORMAL);
         itoa(request_send, string, 10);
         mxyputs(61, 16, string, VID_NORMAL);
      case VDDED_DATA:                         /* VDDED request data */
         CopyToVxD();
         break;

      case VDDED_EXECUTE:
         CopyFromVxD();
         mxyputc(11, 21, ' ', 50, VID_NORMAL);
         mxyputs(11, 21, Buffer, VID_NORMAL_INT);
         break;

      case VDDED_POST:
         CopyFromVxD();
         mxyputc(48, 20, ' ', 30, VID_REVERSE);
         mxyputs(48, 20, Buffer, VID_REVERSE);
         break;
      }
   }

main()
   {
   _asm
      {
      mov     ax,1600h
      int     2Fh                     ; Win - Is enhanced mode running?
      cmp     al,0
      jne     EnhancedModeIsRunning   ; Yes - jump
      jmp     Error1                  ; No - Error1

EnhancedModeIsRunning:

      mov     ax,1684h                ; Get VDDED address
      mov     bx,VDDED_Dev_ID
      int     2fh
      mov     WORD PTR Apientry,di    ; Save the callback address
      mov     WORD PTR Apientry+2,es
      mov     ax,es                   ; Is VDDED installed?
      or      ax,di
      jz      Error2                  ; No - Error2
      mov     ax,1683h                ; Get current virtual machine ID in bx
      int     2fh
      mov     ax, REAL_MODE_CALLBACK
      mov     cx, seg DdeCallBack     ; segment of real mode call back
      mov     dx, offset DdeCallBack  ; offset of real mode call back
      mov     si, seg Buffer          ; segment of real mode buffer
      mov     di, offset Buffer       ; offset of real mode buffer
      call    DWORD PTR Apientry      ; Call VDDED
      cmp     ax,0                    ; If Error
      jz      Error3                  ; Yes - Error3
      cmp     ax,2                    ; If Error
      jz      Error4                  ; Yes Error4
      jmp     OK                      ; Everything is OK
      }

Error1:
   printf("\nEnhanced Mode Windows is not running.\n");
   goto Quit;

Error2:
   printf("\nVDDED.386 is not running.\n");
   goto Quit;

Error3:
   printf("\nSERVER.EXE is already running.\n");
   goto Quit;

Error4:
   printf("\nHELPER.EXE is not running.\n");

Quit:
   exit(0);

OK:

   create_screen();
   while(1)
      if(-1 == read_field(48, 77, 20, Buffer))
         break;
      else
         {
         _asm mov ax,VDDED_DATA
         DdeCallBack();
         _asm mov  ax,UPDATE_DDE
         _asm call DWORD PTR Apientry   ; call VDDED
         }

   clear(0, 0, 80, 25, VID_NORMAL);

   _asm mov     ax, DOS_NOTIFY_QUIT
   _asm call    DWORD PTR Apientry      ; call VDDED
   }

void CopyFromVxD(void)
   {
   _asm mov ax,DOS_COPY_FROM_VXD
   _asm call DWORD PTR Apientry   ; call VDDED
   }

void CopyToVxD(void)
   {
   _asm mov ax,DOS_COPY_TO_VXD
   _asm call DWORD PTR Apientry   ; call VDDED
   }

void create_screen(void)
   {
   vid_mem_one = (char far *)MK_FP(0xB800, 0000);
   clear(0, 0, 80, 25, VID_NORMAL), box_double(0, 0, 79, 24);

   mxyputc(1,   2,  (char)196, 78, VID_NORMAL);
   mxyputc(0,   2,  (char)199, 1,  VID_NORMAL);
   mxyputc(79,  2,  (char)182, 1,  VID_NORMAL);

   mxyputc(1,   7,  (char)196, 78, VID_NORMAL);
   mxyputc(0,   7,  (char)199, 1,  VID_NORMAL);
   mxyputc(79,  7,  (char)182, 1,  VID_NORMAL);

   mxyputc(1,   9, (char)196, 78, VID_NORMAL);
   mxyputc(0,   9, (char)199, 1,  VID_NORMAL);
   mxyputc(79,  9, (char)182, 1,  VID_NORMAL);

   mxyputc(1,   19, (char)196, 78, VID_NORMAL);
   mxyputc(0,   19, (char)199, 1,  VID_NORMAL);
   mxyputc(79,  19, (char)182, 1,  VID_NORMAL);

   mxyputc(1,   22, (char)196, 78, VID_NORMAL);
   mxyputc(0,   22, (char)199, 1,  VID_NORMAL);
   mxyputc(79,  22, (char)182, 1,  VID_NORMAL);

   mxyputs(33,  1, "DDE DOS SERVER", VID_NORMAL);

   mxyputs(26,  3, "**  ENHANCED MODE WINDOWS  **", VID_NORMAL);
   mxyputs(26,  4, "**  SERVER.EXE HELPER.EXE  **", VID_NORMAL);
   mxyputs(26,  5, "**        VDDED.386        **", VID_NORMAL);

   mxyputs(16,  8,  "   Message                    Received     Sent ",
      VID_NORMAL);

   mxyputs(16,  10, "WM_DDE_INITIATE                   0          0  ",
      VID_NORMAL);
   mxyputs(16,  11, "WM_DDE_TERMINATE                  0          0  ",
      VID_NORMAL);
   mxyputs(16,  12, "WM_DDE_ADVISE                     0          0  ",
      VID_NORMAL);
   mxyputs(16,  13, "WM_DDE_UNADVISE                   0          0  ",
      VID_NORMAL);
   mxyputs(16,  14, "WM_DDE_ACK                        0          0  ",
      VID_NORMAL);
   mxyputs(16,  15, "WM_DDE_DATA                       0          0  ",
      VID_NORMAL);
   mxyputs(16,  16, "WM_DDE_REQUEST                    0          0  ",
      VID_NORMAL);
   mxyputs(16,  17, "WM_DDE_POKE                       0          0  ",
      VID_NORMAL);
   mxyputs(16,  18, "WM_DDE_EXECUTE                    0          0  ",
      VID_NORMAL);

   mxyputs(2,   20, "Cost of Clinton's transition team  -  Amount:",
      VID_NORMAL);

   mxyputs(2,   21, "Execute:", VID_NORMAL);

   mxyputs(31,  23, "Press ESC to Exit", VID_NORMAL);
   }

void mxyputs(unsigned char x, unsigned char y, char far *str,
   unsigned char attr)
   {
   while(*str)
      moutchar(x++, y, *str++, attr);
   }

void mxyputc(unsigned char x, unsigned char y, char ch, unsigned char num,
   unsigned char attr)
   {
   unsigned char i;
   for(i = 0; i < num; i++)
      moutchar(x++, y, ch, attr);
   }

void moutchar(unsigned char x, unsigned char y, char ch, unsigned char attr)
   {
   char far *v = vid_mem_one;
   v += y * 160 + x * 2;
   *v++ = ch, *v = attr;
   }

void box_double(unsigned char x1, unsigned char y1, unsigned char x2,
   unsigned char y2)
   {
   register int i;
   char far *v, far *t;
   t = v = vid_mem_one;
   for(i = y1 + 1; i < y2; i++)
      {
      v += i * 160 + x1 * 2;
      *v++ = 186;
      *v = VID_NORMAL;
      v = t;
      v += i * 160 + x2 * 2;
      *v++ = 186;
      *v = VID_NORMAL;
      v = t;
      }
   for(i = x1 + 1; i < x2; i++)
      {
      v += y1 * 160 + i * 2;
      *v++ = 205;
      *v = VID_NORMAL;
      v = t;
      v += y2 * 160 + i * 2;
      *v++ = 205;
      *v = VID_NORMAL;
      v = t;
      }
   moutchar(x1, y1, (char)201, VID_NORMAL);
   moutchar(x1, y2, (char)200, VID_NORMAL);
   moutchar(x2, y1, (char)187, VID_NORMAL);
   moutchar(x2, y2, (char)188, VID_NORMAL);
   }

void clear(unsigned char x1, unsigned char y1, unsigned char x2,
   unsigned char y2, unsigned char attr)
   {
   register unsigned char col, row;
   for(row = y1; row < y2; row++)
      for(col = x1; col < x2; col++)
         moutchar(col, row, (char)32, attr);
   }

int read_field(unsigned char x1, unsigned char x2, unsigned char y,
   char *buffer)
   {
   unsigned char col = x1, row, count;
   gotoxy(x1, y);
   for(count = x1; count <= x2; count++)
      moutchar(count, y, (char)32, VID_REVERSE);
   for(count = x1; ; count++)
      {
      buffer[count - x1] = toupper(keyboard());
      if(buffer[count - x1] == '\r')
         return 0;
      if(buffer[count - x1] == ESC)
         return -1;
      if(buffer[count - x1] == '\b')
         {
         count--;
         if(col != x1)
            {
            moutchar(--col, y, (char)32, VID_REVERSE);
            count--;
            }
         }
      else
         moutchar(col++, y, buffer[count - x1], VID_REVERSE);
      if(col < x1)
         col = x1;
      else
         if(col > x2 + 1)
            {
            count--;
            col = x2 + 1;
            moutchar(col, y, (char)32, VID_NORMAL);
            }
      gotoxy(col, y);
      }
   buffer[count - x1] = 0;
   return 0;
   }

void gotoxy(unsigned char x, unsigned char y)
   {
   union REGS i;
   i.h.dh = y;
   i.h.dl = x;
   i.h.ah = 2;
   i.h.bh = 0;
   (void)int86(16, &i, &i);                
   }

unsigned far keyboard(void)
   {
   unsigned ret_val;
   while(1)
      if(_bios_keybrd(_KEYBRD_READY) != 0)
         break;
   ret_val = _bios_keybrd(_KEYBRD_READ);
   ret_val =
      (ret_val & 0x00ff) ? (ret_val & 0x00ff) : ((ret_val & 0xff00) / 0xff);
   return(ret_val);
   }

