;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                            ;
; Listing 2                                                                  ;
;                                                                            ;
; WDDJDDED.386 - DDE to DOS VxD                                                 ;
;                                                                            ;
; Written by Guy Eddon, 1992                                                 ;
;                                                                            ;
; Put this in the [386Enh] section of your SYSTEM.INI file                   ;
;                                                                            ;
; Build with the MS Windows 3.1 DDK:                                         ;
;                                                                            ;
;    masm5 -p -w2 -Mx wddjdded.asm;                                             ;
;    link386 /NOI /NOD /NOP wddjdded,wddjdded.386,NUL,,wddjdded.def;                  ;
;    addhdr wddjdded.386                                                        ;
;                                                                            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PAGE 58,132
TITLE WDDJDDED
.386p

.XLIST
INCLUDE VMM.INC
INCLUDE VDD.INC
.LIST

; #defines for communication with HERLPER and SERVER
UPDATE_DDE          equ 7777h                  ; Server has data
REAL_MODE_CALLBACK  equ 5555h                  ; Give VxD real mode address
VDDED_Dev_ID        equ 305Fh                  ; VDDED VxD ID
TEST_DOS            equ 8888h                  ; Test if Server has data
WINDOWS_CHECK       equ 8889h                  ; Helper test if Server running
EXIT_DOS            equ 8890h                  ; Server exit notify value
WINDOWS_NOTIFY_QUIT equ 8891h                  ; Helper exit notify message
CLEAR_DOS           equ 9999h                  ; Helper got Server's data
DOS_NOTIFY_QUIT     equ 0299h                  ; Server exit notify message
DOS_COPY_TO_VXD     equ 1623h                  ; Server has data
DOS_COPY_FROM_VXD   equ 1624h

WM_DDE_FIRST	    equ 03E0h                  ; Same as DDE.H #defines
WM_DDE_INITIATE     equ (WM_DDE_FIRST)
WM_DDE_TERMINATE    equ (WM_DDE_FIRST+1)
WM_DDE_ADVISE	    equ (WM_DDE_FIRST+2)
WM_DDE_UNADVISE     equ (WM_DDE_FIRST+3)
WM_DDE_ACK	    equ (WM_DDE_FIRST+4)
WM_DDE_DATA	    equ (WM_DDE_FIRST+5)
WM_DDE_REQUEST	    equ (WM_DDE_FIRST+6)
WM_DDE_POKE	    equ (WM_DDE_FIRST+7)
WM_DDE_EXECUTE	    equ (WM_DDE_FIRST+8)
WM_DDE_LAST	    equ (WM_DDE_FIRST+8)

VDDED_CB_DATA STRUC

VDDED_State  dd   ?

VDDED_CB_DATA ENDS

Declare_Virtual_Device WDDJDDED, 3, 0, VDDED_Control, VDDED_Dev_ID, , VDDED_API_PROC, VDDED_API_Proc

VxD_LOCKED_DATA_SEG
ALIGN   4

WM_DDE_type                dd  0
SendReceive                dd  0
Pointer_To_DOS_Program     dd  0
Pointer_To_Windows_Program dd  0
DOSHasData                 dd  0
DOS_Running                dd  0
WINDOWS_Running            dd  0
DOS_VM_ID                  dd  0
DOS_LINEAR_BUFFER          dd  0
WIN_LINEAR_BUFFER          dd  0
DOS_Seg                    dw  0
DOS_Off                    dw  0
WIN_Sel                    dw  0
WIN_Off                    dw  0

VxD_LOCKED_DATA_ENDS

VxD_ICODE_SEG

VxD_ICODE_ENDS

VxD_LOCKED_CODE_SEG

BeginProc VDDED_Control

        ret

EndProc VDDED_Control

VxD_LOCKED_CODE_ENDS

VxD_CODE_SEG

BeginProc VDDED_API_Proc

        push    ebx                            ; Save ebx

        movzx   eax, WORD PTR [ebp.Client_BX]
        mov     SendReceive,eax                ; SendReceive = client bx
        movzx   eax, WORD PTR [ebp.Client_AX]  ; eax = client ax
                                               ; switch(eax)
        cmp     eax, WINDOWS_NOTIFY_QUIT       ; case WINDOWS_NOTIFY_QUIT:
        jz      SHORT HelperIsQuiting
        cmp     eax, DOS_NOTIFY_QUIT           ; case DOS_NOTIFY_QUIT:
        jz      SHORT ServerIsQuiting             
        cmp     eax, WINDOWS_CHECK             ; case WINDOWS_CHECK:
        jz      SHORT HelperCheck
        cmp     eax, CLEAR_DOS                 ; case CLEAR_DOS:
        jz      ResetVariable
        cmp     eax, TEST_DOS                  ; case TEST_DOS:
        jz      TestVariable
        cmp     eax, UPDATE_DDE                ; case UPDATE_DDE:
        jz      Call_Windows_Program
        cmp     eax, REAL_MODE_CALLBACK        ; case REAL_MODE_CALLBACK:
        jz      SHORT real_mode
        cmp     eax, DOS_COPY_TO_VXD
        jz      get_data_from_dos
        cmp     eax, DOS_COPY_FROM_VXD
        jz      put_data_to_dos
        mov     WM_DDE_type, eax               ; default:
        jmp     Call_DOS_Program

HelperIsQuiting:
        mov     WINDOWS_Running,0              ; Helper just quit
        jmp     VDDED_exit

ServerIsQuiting:
        mov     DOS_Running,0                  ; Server just quit
        jmp     VDDED_exit

HelperCheck:
        mov     WINDOWS_Running,1              ; Helper just started
        mov     [ebp.Client_AX],1              ; Yes - return 1
        mov     ax,[ebp.Client_BX]
        mov     WIN_Sel,ax
        mov     ax,[ebp.Client_CX]
        mov     WIN_Off,ax
        jmp     VDDED_exit

No_NOT_Running:
        mov     [ebp.Client_AX],0              ; Return 0
        jmp     VDDED_exit

real_mode:
        cmp     WINDOWS_Running,0              ; Is Helper running?
        jz      SHORT Helper_NOT_RUNNING       ; No - jump
        cmp     DOS_Running,1                  ; Yes - Is Server running
        jz      SHORT Server_ALREADY_RUNNING   ; Yes - jump
        movzx   eax,[ebp.Client_BX]            ; VM ID of DOS box
        mov     DOS_VM_ID,eax
        movzx   eax,[ebp.Client_CX]            ; No - real mode address
        mov     WORD PTR Pointer_To_DOS_Program,ax
        movzx   eax,[ebp.Client_DX]            ; Put it in Pointer_To_DOS_Program
        mov     WORD PTR Pointer_To_DOS_Program+2,ax
        mov     DOS_Running,1                  ; Return 1
        mov     ax,[ebp.Client_SI]
        mov     DOS_Seg,ax
        mov     ax,[ebp.Client_DI]
        mov     DOS_Off,ax
        mov     [ebp.Client_AX],1
        jmp     VDDED_exit

Helper_NOT_RUNNING:
        mov     [ebp.Client_AX],2              ; Return 2
        jmp     VDDED_exit

Server_ALREADY_RUNNING:
        mov     [ebp.Client_AX],0              ; Return 0
        jmp     VDDED_exit

TestVariable:
        cmp     DOS_Running,0                  ; Is Server running?
        jz      SHORT DOS_Quit                 ; No - jump
        mov     eax,DOSHasData                 ; Yes
        mov     [ebp.Client_AX],ax             ; client ax = DOSHasData
        jmp     VDDED_exit

DOS_Quit:
        mov     [ebp.Client_AX],EXIT_DOS       ; Return EXIT_DOS
        jmp     VDDED_exit

ResetVariable:
        mov     DOSHasData,0                   ; DOSHasData = 0
        jmp     VDDED_exit

Call_DOS_Program:
        mov     eax, DOS_VM_ID                 ; Get requested VMID
        or      eax, eax                       ; non-zero?
        jz      short vmcb_ok                  ; zero, ebx is correct
vmid_scan:
        cmp     eax, [ebx.CB_VMID]             ; found it?
        je      short vmcb_ok                  ; yes
        VMMCall Get_Next_VM_Handle             ; get next
        VMMCall Test_Cur_VM_Handle             ; back to start of list?
        jne     vmid_scan                      ; no
        jmp     VDDED_exit
vmcb_ok:
        mov     esi, OFFSET32 DOSEventCallBack ; esi = &DOSEventHandler
        VMMCall Schedule_VM_Event              ; Schedule_VM_Event
        VMMCall Set_Execution_Focus            ; Switch to VM and execute call
        jmp     VDDED_exit

Call_Windows_Program:
        mov     DOSHasData,1                   ; DOSHasData = 1
        jmp     VDDED_exit

put_data_to_dos:
        mov     eax, DOS_VM_ID                 ; Get requested VMID
        or      eax, eax                       ; non-zero?
        jz      short vmcb_ok_dos1                  ; zero, ebx is correct
vmid_scan_dos1:
        cmp     eax, [ebx.CB_VMID]             ; found it?
        je      short vmcb_ok_dos1                  ; yes
        VMMCall Get_Next_VM_Handle             ; get next
        VMMCall Test_Cur_VM_Handle             ; back to start of list?
        jne     vmid_scan_dos1                      ; no
        jmp     VDDED_exit
vmcb_ok_dos1:
        mov     esi, OFFSET32 DOSGetMapFlatAddr
        VMMCall Schedule_VM_Event              ; Schedule_VM_Event
        VMMCall Set_Execution_Focus            ; Switch to VM and execute call
        VMMCall Get_Sys_VM_Handle
        mov     esi, OFFSET32 WINGetMapFlatAddr
        VMMCall Schedule_VM_Event              ; Schedule_VM_Event
        VMMCall Set_Execution_Focus            ; Switch to VM and execute call
        mov     edi,0
        mov     cx,50
        mov     eax, DOS_LINEAR_BUFFER
        mov     ebx, WIN_LINEAR_BUFFER
begin_y:
        mov     dh,byte ptr [ebx+edi]
        mov     byte ptr [eax+edi],dh
        inc     edi
        loop    begin_y
        jmp     SHORT VDDED_exit

get_data_from_dos:
        mov     eax, DOS_VM_ID                 ; Get requested VMID
        or      eax, eax                       ; non-zero?
        jz      short vmcb_ok_dos2                  ; zero, ebx is correct
vmid_scan_dos2:
        cmp     eax, [ebx.CB_VMID]             ; found it?
        je      short vmcb_ok_dos2                  ; yes
        VMMCall Get_Next_VM_Handle             ; get next
        VMMCall Test_Cur_VM_Handle             ; back to start of list?
        jne     vmid_scan_dos2                      ; no
        jmp     short VDDED_exit
vmcb_ok_dos2:
        mov     esi, OFFSET32 DOSGetMapFlatAddr
        VMMCall Schedule_VM_Event              ; Schedule_VM_Event
        VMMCall Set_Execution_Focus            ; Switch to VM and execute call
        VMMCall Get_Sys_VM_Handle
        mov     esi, OFFSET32 WINGetMapFlatAddr
        VMMCall Schedule_VM_Event              ; Schedule_VM_Event
        VMMCall Set_Execution_Focus            ; Switch to VM and execute call
        mov     edi,0
        mov     cx,50
        mov     eax, DOS_LINEAR_BUFFER
        mov     ebx, WIN_LINEAR_BUFFER
begin_x:
        mov     dh,byte ptr [eax+edi]
        mov     byte ptr [ebx+edi],dh
        inc     edi
        loop    begin_x
        jmp     SHORT VDDED_exit

VDDED_exit:
        pop     ebx                            ; Restore ebx
        ret

EndProc VDDED_API_Proc

BeginProc DOSEventCallBack                     ; Now executing with VM focus

        Push_Client_State                      ; Save client state
        VMMCall Begin_Nest_V86_Exec            ; Enter nested code
        movzx   ecx,WORD PTR Pointer_To_DOS_Program
        movzx   edx,WORD PTR Pointer_To_DOS_Program+2
        mov     eax,WM_DDE_type                ; eax = WM_DDE_type
        mov     ebx,SendReceive                ; ebx = SendRecieve
        mov     [ebp.Client_AX],ax             ; client ax = ax
        mov     [ebp.Client_BX],bx             ; client bx = bx
        VMMCall Simulate_Far_Call              ; Call code in VM
        VMMCall Resume_Exec                    ; Do it
        VMMCall End_Nest_Exec                  ; Exit nested code
        Pop_Client_State                       ; Restore client state
        ret

EndProc DOSEventCallBack

BeginProc DOSGetMapFlatAddr

        Push_Client_State                      ; Save client state
        VMMCall Begin_Nest_V86_Exec            ; Enter nested code

        mov     ax,DOS_Seg
        mov     [ebp.Client_SI],ax
        mov     ax,DOS_Off
        mov     [ebp.Client_DI],ax
        mov     ax,(Client_SI SHL 8) + Client_DI
        VMMCall Map_Flat
        mov     DOS_LINEAR_BUFFER,eax

        VMMCall Resume_Exec                    ; Do it
        VMMCall End_Nest_Exec                  ; Exit nested code
        Pop_Client_State                       ; Restore client state
        ret

EndProc DOSGetMapFlatAddr

BeginProc WINGetMapFlatAddr

        Push_Client_State                      ; Save client state
        VMMCall Begin_Nest_Exec            ; Enter nested code

        mov     ax,WIN_Sel
        mov     [ebp.Client_SI],ax
        mov     ax,WIN_Off
        mov     [ebp.Client_DI],ax
        mov     ax,(Client_SI SHL 8) + Client_DI
        VMMCall Map_Flat
        mov     WIN_LINEAR_BUFFER,eax

        VMMCall Resume_Exec                    ; Do it
        VMMCall End_Nest_Exec                  ; Exit nested code
        Pop_Client_State                       ; Restore client state
        ret

EndProc WINGetMapFlatAddr

VxD_CODE_ENDS

        END                                    ; That's all folks!

