#include <windows.h>
#include "mnugrp.h"

static HBITMAP hBmp = NULL;


void FAR PASCAL CheckMenuGroup( HMENU hMenu, int idFirst,
    int idLast, int idCheck )
{
    register int c;

    if( hBmp == NULL )
        {
        DWORD dwDimensions;
        HDC hdc;
        HDC hdc2;
        int x1, y1;
        int nWidth;

        hdc = CreateDC( "DISPLAY", NULL, NULL, NULL );
        dwDimensions = GetMenuCheckMarkDimensions();
        hBmp = CreateBitmap( LOWORD( dwDimensions ),
                            HIWORD( dwDimensions ),    1, 1, NULL );
        hdc2 = CreateCompatibleDC( hdc );
        DeleteDC( hdc );
        SelectObject( hdc2, hBmp );
        PatBlt( hdc2, 0, 0, LOWORD( dwDimensions ),
                  HIWORD( dwDimensions ), WHITENESS );
        nWidth = ( LOWORD( dwDimensions ) / 4 ) * 2;
        x1 = ( nWidth / 2 ) + 1;
        y1 = ( HIWORD( dwDimensions ) - nWidth ) / 2;
        SelectObject( hdc2, GetStockObject( BLACK_PEN ) );
        SelectObject( hdc2, GetStockObject( BLACK_BRUSH ) );
        Ellipse( hdc2, x1, y1, x1 + nWidth, y1 + nWidth );
        DeleteDC( hdc2 );
        }
    for( c = idFirst; c <= idLast; ++c )
        {
        SetMenuItemBitmaps( hMenu, c, MF_BYCOMMAND,
                                  NULL, hBmp );
        CheckMenuItem( hMenu, c, MF_BYCOMMAND |
            ( c == idCheck ) ? MF_CHECKED : MF_UNCHECKED );
        }
}

void FAR PASCAL DeleteCheckMenuItemGroupBitmap( void )
{
    if( hBmp )
        DeleteObject( hBmp );
}
