/**************************************************
  Test rig for Shadowed Popup Window
**************************************************/

#include <windows.h>
#include "mnugrp.h"
#include "testrc.h"

HINSTANCE hInst;        /* Application instance handle  */
HMENU hMenu;            /* Handle of menu               */

LONG FAR PASCAL _export TestRigProc( HWND, UINT, WPARAM, LPARAM );

void DoCommand( HWND hwnd, int id );

/***************************************************/
/* WinMain                                         */
/***************************************************/

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(
    HINSTANCE hInstance,
    HINSTANCE hPrevInstance,
    LPSTR lpszCmdLine,
    int nCmdShow )
{
    WNDCLASS wc;
    HWND hwnd;
    MSG msg;

    hInst                   = hInstance;

    wc.style                = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc          = TestRigProc;
    wc.cbClsExtra           = 0;
    wc.cbWndExtra           = 0;
    wc.hInstance            = hInst;
    wc.hIcon                = NULL;
    wc.hCursor              = LoadCursor( NULL, IDC_ARROW );
    wc.hbrBackground        = (HBRUSH)( COLOR_APPWORKSPACE
                                                      + 1 );
    wc.lpszMenuName         = NULL;
    wc.lpszClassName        = "testrig";
    if( !RegisterClass( &wc ) )
        return( FALSE );

    hMenu = LoadMenu( hInst, RIGMENU );

    hwnd = CreateWindow( "testrig",
        "CheckMenuGroup function demonstration",
        WS_OVERLAPPEDWINDOW, CW_USEDEFAULT,
        CW_USEDEFAULT, CW_USEDEFAULT,
        CW_USEDEFAULT, NULL, hMenu, hInst, NULL );
    ShowWindow( hwnd, nCmdShow );
    UpdateWindow( hwnd );

    while( GetMessage( &msg, NULL, 0, 0 ) ) {
        TranslateMessage( &msg );
        DispatchMessage( &msg );
        }
    return( (int)msg.wParam );
}


LONG FAR PASCAL _export TestRigProc(
    HWND hwnd,
    UINT message,
    WPARAM wParam,
    LPARAM lParam )
{
    switch( message )
        {
        case WM_CREATE:
            CheckMenuGroup( hMenu, IDM_VIEW50,
                                 IDM_VIEW200, IDM_VIEW50 );
            break;

        case WM_CLOSE:
            DeleteCheckMenuItemGroupBitmap();
            DestroyWindow( hwnd );
            PostQuitMessage( 0 );
            return( 0L );

        case WM_COMMAND:
            DoCommand( hwnd, wParam );
            return( 0L );
        }
    return( DefWindowProc( hwnd, message, wParam, lParam ) );
}

void DoCommand( HWND hwnd, int id )
{
    switch( id )
        {
        case IDM_VIEW50:
        case IDM_VIEW100:
        case IDM_VIEW200:
            CheckMenuGroup( hMenu, IDM_VIEW50,
                                 IDM_VIEW200, id );
            DrawMenuBar( hwnd );
            break;

        case IDM_EXIT:
            SendMessage( hwnd, WM_CLOSE, 0, 0L );
            break;
        }
}

