#include <string.h>
#include <windows.h>

#define  APPEND_SYMBOL              '~'
#define  MAX_RESOURCE_STRING_LEN    255
#define  MAX_WVSPRINTF_OUTPUT       1024

int GeneralMessageBox (HWND   hWnd,
                       HINSTANCE hInst,
                       WORD   wType,
                       int    nCaptionID,
                       int    nTextID,
                       ...)
{
   char     szCaption [MAX_RESOURCE_STRING_LEN];
   char     szText [MAX_RESOURCE_STRING_LEN];
   HGLOBAL  hFormat     = NULL;
   LPSTR    lpFormat    = NULL;
   HGLOBAL  hOutput     = NULL;
   LPSTR    lpOutput    = NULL;
   BOOL     bContinue   = TRUE;
   LPLONG   lpParams    = (LPLONG) (&nTextID + 1);
   int      Ret         = 0;

   /*
   *  Get the caption string.  If <nCaptionID> is
   *  non-zero, use as ID.  Otherwise, get string
   *  pointer from variable parameter list.
   */
   strcpy (szCaption, "");
   if (nCaptionID)
      LoadString (hInst, nCaptionID, szCaption,
                  sizeof szCaption);
   else
      lstrcpy (szCaption, (LPSTR) *lpParams++);

   /* Allocate buffer to hold the string resource. */
   if ((hFormat = GlobalAlloc (GHND,
                     MAX_WVSPRINTF_OUTPUT)) == NULL)
      goto exit;
   if ((lpFormat = GlobalLock (hFormat)) == NULL)
      goto exit;

   /* Fill <lpFormat> with the full format string. */
   if (nTextID == 0)
      lstrcpy (lpFormat, (LPSTR) *lpParams++);
   else
      while (bContinue)
         {
            /*
            *  Get the text string.  If <nCaptionID> is
            *  is non-zero, use as ID.  Otherwise, get
            *  string pointer from variable parameter
            *  list.
            */
            if (LoadString (hInst, nTextID++,
                           szText, sizeof szText) == 0)
               break;

            /* Don't overflow <lpFormat>. */
            if ((lstrlen (lpFormat) + lstrlen (szText))
                     >= MAX_WVSPRINTF_OUTPUT)
               break;

            /* Concatenate the next resource string? */
            bContinue = (szText [0] == APPEND_SYMBOL);
            lstrcat (lpFormat, (bContinue ?
                                szText + 1 : szText));
         }

   /* Format string with variable parm list (if any) */
   if ((hOutput = GlobalAlloc (GHND,
                     MAX_WVSPRINTF_OUTPUT)) == NULL)
      goto exit;
   if ((lpOutput = GlobalLock(hOutput)) == NULL)
      goto exit;

   wvsprintf (lpOutput, lpFormat, lpParams);

   /* Display the message box. */
   Ret = MessageBox (hWnd,
                     lpOutput,
                     szCaption,
                     wType);

exit:
   if (lpFormat)     GlobalUnlock (hFormat);
   if (hFormat)      GlobalFree (hFormat);

   if (lpOutput)     GlobalUnlock (hOutput);
   if (hOutput)      GlobalFree (hOutput);

   return (Ret) ;
}
