/*
 *  bioskb.c
 *      Keyboard functions using the BIOS keyboard services
 *      Written by Fred Smith, 4/93
 */

/*
 * get_kbch():
 *  Returns the next non-function-key keypress.
 */

char get_kbch(void)
{
start:
    _asm {
        mov ah, 0
        int 16h
        cmp al, 0
        jz start    /* ignore extended keys */
        mov ah, 0
    }
}


/*
 * check_keybrd():
 *  Returns 0 if no keypress pending,
 *      else returns the keypress.
 *  Function keys are ignored, as in get_kbch()
 */

int check_keybrd (void)
{
    _asm jmp start
        
flush:
    _asm {
        mov ah, 0
        int 16h
    }

start:
    _asm {
        mov ah, 1
        int 16h
        jz none         /* no keystroke pending */
        cmp al, 0
        jz flush        /* ignore extended key  */
        jmp endit
    }

none:
    _asm mov ax, 0

endit:
}
