/* written by Bhavdeep Singh - for Windows/DOS Developer's Journal */
/* Compiler: MS C/C++ 7.0a      */
/* Linker:   MS Link  5.31.009  */
/* Make:     MS Nmake 1.2       */

#define  STRICT             /* Move to WinNT, someday */
#include "windows.h"        /* The Windows World */
#include <stdio.h>          /* for ?printf */
#include <stdarg.h>         /* for variable arg list */
#define PROGRAM "DBWIN.EXE" /* Use full path here if DBWIN.EXE and DBWIN.DLL
                   are not in your PATH e.g. "c:\\WinDev\\Bin\\DBWIN.EXE" */

int PASCAL WinMain (HINSTANCE, HINSTANCE, LPSTR, int);
static void NEAR PASCAL OutString (char *);
static void NEAR _cdecl OutFormat ( char *, ...);

int PASCAL WinMain (
     HINSTANCE hInstance,       /* handle of current instance */
     HINSTANCE hPrevInstance,   /* handle of previous instance */
     LPSTR     lpCmdLine,       /* long ptr to command line */
     int       nCmdShow         /* show-window state */
     )
{
   OutString ("\nWindows/DOS Developers Journal, Tech. Tip.\nVersion: ");
   OutString (__TIMESTAMP__);
   OutString ("\n");
   OutFormat ("Source \"%s\"\nLine# %i\n", __FILE__, __LINE__);
   return FALSE;                /* exit code */ 
}

static void NEAR PASCAL OutString (char *pszStr)
{
   /* if !running PROGRAM WinExec it ! */
   if (!FindWindow((LPCSTR)"DBWIN", (LPCSTR)"Debug Messages")) 
      WinExec ((LPCSTR)PROGRAM, SW_SHOWNORMAL);
   /* if the PROGRAM is running, (i.e. WinExec didnot fail) go ahead */
   if (FindWindow((LPCSTR)"DBWIN", (LPCSTR)"Debug Messages"))
      OutputDebugString(pszStr);
}

static void NEAR _cdecl OutFormat ( char * pszFormat, ...)
{
    char    szStr[256];
    va_list va_ptr;

    va_start (va_ptr, pszFormat);
    vsprintf (szStr, pszFormat, va_ptr);
    va_end (va_ptr);
    OutString (szStr);
}
/* EOF DBG.C */
