/*
 *  doskb.c
 *      Keyboard functions using DOS services
 *      Written by Fred Smith, 4/93
 */

#include <io.h>
#include <fcntl.h>      /* for open()        */

static int kbfd;        /* private file handle for keyboard */

/*
 * get_kbch():
 *  Get one character from keyboard.
 *  Ignores function/keypad keys.
 */

char get_kbch(void)
{
    int ch;

    while (1)
    {
        read (kbfd, &ch, 1);
        if (ch == 0)        /* if extended key, ignore it */
            read (kbfd, &ch, 1);
        else
            break;
    }
    return (ch);
}


/*
 * init_kb():
 *  Open keyboard and set up for raw reads.
 */

int init_kb(void)
{

    kbfd = open ("CON", O_RDONLY);  /* open for read */
    if (kbfd < 0)
        return (-1);

    /* set the newly opened device into raw mode */
    _asm {
        mov ax, 4400h   /* get current device parameters */
        mov bx, kbfd
        int 21h
        mov dh, 0
        or dl, 20h      /* set raw mode */
        mov ax, 4401h   /* set new parameters */
        int 21h
        }

    return (kbfd);
}
