/*
 *  tcvbreak.c
 *      A test driver for M. Levy's conditional breakpoint Tip
 *  Written by Leor Zolman, 4/93
 *  Compile/Link for CodeView (Microsoft Visual C++ 1.0):
 *      cl /Zi tcvbreak.c
 */

#include <stdio.h>

#define DEBUG 1             /* set to 0 for no debugging */

#define BreakPoint  _asm int 3h

#if DEBUG
#   define BreakOn(e)  if (!(e)); else BreakPoint
#   define AssertB(e)  if ((e)); else BreakPoint
#else
#   define BreakOn(e)
#   define AssertB(e)
#endif

#define NLOOPS 2000000      /* takes about 2 seconds on my 486/66 */

main()
{
    long count, dummy;
    
    for (count = 0; count < NLOOPS; count++)
    {
        dummy = count + 50;
        BreakOn(count > (NLOOPS - 100))     /* Enter debugger only
                                                near end of run */
    }
    printf("Done with %ld loops.\n", NLOOPS);
}
