#if defined(SIMPLE_HELLO_WORLD)

#include <stdio.h>
#include <windows.h>

main()
{
     printf("Hello, world!\n");
}

/**********************************************************/
#elseif defined(CONSOLE_API_HELLO_WORLD)

#include <stdio.h>
#include <windows.h>

main()
{
    int n;

     AllocConsole();

     WriteFile(GetStdHandle(STD_OUTPUT_HANDLE), "Hello, world!\n",
               strlen("Hello, world!\n"), &n, NULL);
}

/**********************************************************/
#elseif defined(CONSOLE_API_WITH_WAIT)

#include <stdio.h>
#include <windows.h>

HANDLE StdIn, StdOut, StdErr;


main()
{
    int n;

    /* Free existing console, start up new one to   *
     * get a separate window                        */
    FreeConsole();
    AllocConsole();

    /* Get standard handles */
    StdIn = GetStdHandle(STD_INPUT_HANDLE);
    StdOut = GetStdHandle(STD_OUTPUT_HANDLE);
    StdErr = GetStdHandle(STD_ERROR_HANDLE);

    /* Put console into raw mode */
    GetConsoleMode(StdIn, &dwFlags);
    SetConsoleMode(StdIn, dwFlags & ~(ENABLE_LINE_INPUT |
                                        ENABLE_ECHO_INPUT));

    /* Write the string  */
    WriteFile(StdOut, "Hello, world!\n",
                       strlen("Hello, world!\n"), &n, NULL);

    /* Read in a single character */
    ReadFile(StdIn, &c, 1, &n, NULL);
}


#endif
