/**************************************************

  MRU Menu function source code

**************************************************/

#include <windows.h>
#include "mrulist.h"

static int nMaxItems = 4;   /* Maximum number of items
                               in the MRU list              */
static HWND hwndMDI = NULL; /* Handle of MDI client window  */
static int cFile = 0;       /* Number of remembered files   */
static int cFileList = 0;   /* Number of files in File menu
                               list                         */
static char pszFile[ 9 ][ 144 ]; /* Remembered file names   */
static char szWinIni[] = "WIN.INI";
static char szDefKey[] = "files";

void FAR PASCAL InitMRUList( int nItems, HWND hMDIWnd )
{
    nMaxItems = nItems < 1 ? 1 : nItems > 9 ? 9 : nItems;
    hwndMDI = hMDIWnd;
}

void FAR PASCAL AddMRUItem( HWND hwnd, char * pName )
{
    register int c;

    for( c = 0; c < cFile; ++c )
        if( lstrcmpi( pszFile[ c ], pName ) == 0 )
            {
            for( ; c < cFile; ++c )
                lstrcpy( pszFile[ c ], pszFile[ c + 1 ] );
            --cFile;
            break;
            }
    if( cFile == nMaxItems )
        --cFile;
    for( c = cFile; c; --c )
        lstrcpy( pszFile[ c ], pszFile[ c - 1 ] );
    lstrcpy( pszFile[ 0 ], pName );
    ++cFile;
    UpdateMRUList( hwnd );
}

void FAR PASCAL DeleteMRUItem( HWND hwnd,
    char * pName )
{
    register int c;

    for( c = 0; c < cFile; ++c )
        if( lstrcmpi( pszFile[ c ], pName ) == 0 )
            {
            for( ; c < cFile; ++c )
                lstrcpy( pszFile[ c ], pszFile[ c + 1 ] );
            --cFile;
            break;
            }
    UpdateMRUList( hwnd );
}

BOOL FAR PASCAL GetMRUItem( int id, LPSTR lpsz )
{
    if( id - IDM_FILE1 <= cFile )
        lstrcpy( lpsz, pszFile[ id - IDM_FILE1 ] );
    else
        *lpsz = '\0';
    return( *lpsz != '\0' );
}

void FAR PASCAL AppendMRUList( HWND hwnd )
{
    if( cFile )
        {
        register int c;
        register int nFile;
        register int cCount;
        HMENU hMenu;

        nFile = 0;
        if( hwndMDI )
            if( HIWORD( SendMessage( hwndMDI, WM_MDIGETACTIVE,
                            0, 0L ) ) )
                ++nFile;
        hMenu = GetMenu( hwnd );
        hMenu = GetSubMenu( hMenu, nFile );
        cCount = GetMenuItemCount( hMenu );
        --cCount;
        for( c = 0; c < cFile; ++c ) {
            char sz[ 160 ];

            wsprintf( sz, "&%d %s", c + 1,
                         (LPSTR)pszFile[ c ] );
            InsertMenu( hMenu, cCount++,
                        MF_STRING|MF_BYPOSITION,
                        IDM_FILE1 + c, sz );
            }
        InsertMenu( hMenu, cCount,
                        MF_SEPARATOR|MF_BYPOSITION, 0, NULL );
        cFileList = cFile;
        }
}

void FAR PASCAL UpdateMRUList( HWND hwnd )
{
    register int c;
    char sz[ 160 ];
    HMENU hMenu;
    int cCount;
    int nFile;

    nFile = 0;
    if( hwndMDI )
        if( HIWORD( SendMessage( hwndMDI, WM_MDIGETACTIVE,
                        0, 0L ) ) )
            ++nFile;
    hMenu = GetMenu( hwnd );
    hMenu = GetSubMenu( hMenu, nFile );
    cCount = GetMenuItemCount( hMenu );
    --cCount;
    for( c = 0; c < min( cFile, cFileList ); ++c ) {
        wsprintf( sz, "&%d %s", c + 1, (LPSTR)pszFile[ c ] );
        ModifyMenu( hMenu, IDM_FILE1 + c, MF_STRING,
                        IDM_FILE1 + c, sz );
        }
    if( cFileList < cFile ) {
        if( cFileList == 0 )
            InsertMenu( hMenu, cCount,
                            MF_SEPARATOR|MF_BYPOSITION,
                            0, NULL );
        else
            --cCount;
        for( c = cFileList; c < cFile; ++c ) {
            wsprintf( sz, "&%d %s", c + 1,
                         (LPSTR)pszFile[ c ] );
            InsertMenu( hMenu, cCount++,
                            MF_STRING|MF_BYPOSITION,
                            IDM_FILE1 + c, sz );
            }
        }
    else
        for( c = cFile; c < cFileList; ++c )
            DeleteMenu( hMenu, IDM_FILE1 + c, MF_BYCOMMAND );
    if( cFileList > 0 && cFile == 0 )
        DeleteMenu( hMenu, 999, MF_BYCOMMAND );
    cFileList = cFile;
    DrawMenuBar( hwnd );
}

void FAR PASCAL LoadMRUList( HWND hwnd, LPSTR szIniFile,
    LPSTR szKey )
{
    register int c;

    if( szIniFile == NULL )
        szIniFile = szWinIni;
    if( szKey == NULL )
        szKey = szDefKey;
    for( c = IDM_FILE1+(nMaxItems - 1); c >= IDM_FILE1; --c )
        {
        char sz[ 144 ];
        char sz2[ 6 ];

        wsprintf( sz2, "File%d", ( c - IDM_FILE1 ) + 1 );
        if( GetPrivateProfileString( szKey, sz2, "", sz,
                    144, szIniFile ) )
            AddMRUItem( hwnd, sz );
        }
}

void FAR PASCAL SaveMRUList( LPSTR szIniFile, LPSTR szKey )
{
    register int c;

    if( szIniFile == NULL )
        szIniFile = szWinIni;
    if( szKey == NULL )
        szKey = szDefKey;
    for( c = IDM_FILE1; c < IDM_FILE4 + nMaxItems; ++c ) {
        char sz[ 144 ];
        char sz2[ 6 ];

        wsprintf( sz2, "File%d", ( c - IDM_FILE1 ) + 1 );
        if( GetMRUItem( c, sz ) )
            WritePrivateProfileString( szKey, sz2, sz,
                    szIniFile );
        else
            WritePrivateProfileString( szKey, sz2, NULL,
                    szIniFile );
        }
}

