/**************************************************

  Test rig for MRUList menu functions

**************************************************/

#include <windows.h>
#include <commdlg.h>
#include "mrulist.h"
#include "testrc.h"

HINSTANCE hInst;		/* Application instance handle */
HMENU hMenu;			/* Handle of menu */

LONG FAR PASCAL TestRigProc( HWND, UINT,
							WPARAM, LPARAM );

void DoCommand( HWND hwnd, int id );

/***************************************************/
/* WinMain														*/
/***************************************************/

int PASCAL WinMain(
	HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPSTR lpszCmdLine,
	int nCmdShow )
{
	WNDCLASS wc;
	HWND hwnd;
	MSG msg;

	hInst  				= hInstance;

	wc.style				= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc		= TestRigProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInst;
	wc.hIcon				= NULL;
	wc.hCursor			= LoadCursor( NULL, IDC_ARROW );
	wc.hbrBackground	= (HBRUSH)( COLOR_APPWORKSPACE + 1 );
	wc.lpszMenuName	= NULL;
	wc.lpszClassName	= "testrig";
	if( !RegisterClass( &wc ) )
		return( FALSE );

	hMenu = LoadMenu( hInst, RIGMENU );

	hwnd = CreateWindow( "testrig", "MRU List Test Rig",
		WS_OVERLAPPEDWINDOW, CW_USEDEFAULT,
		CW_USEDEFAULT, CW_USEDEFAULT,
		CW_USEDEFAULT, NULL, hMenu, hInst, NULL );
	ShowWindow( hwnd, nCmdShow );
	UpdateWindow( hwnd );

	InitMRUList( 6, NULL );	/* 6 items - No MDI windows */
	LoadMRUList( hwnd, "mrulist.ini", NULL );

	while( GetMessage( &msg, NULL, 0, 0 ) ) {
		TranslateMessage( &msg );
		DispatchMessage( &msg );
		}
	return( (int)msg.wParam );
}

/***************************************************/
/* TestRigProc													*/
/***************************************************/

LONG FAR PASCAL TestRigProc(
	HWND hwnd,
	UINT message,
	WPARAM wParam,
	LPARAM lParam )
{
	switch( message )
		{
		case WM_CLOSE:
			SaveMRUList( "mrulist.ini", NULL );
			DestroyWindow( hwnd );
			PostQuitMessage( 0 );
			break;

		case WM_COMMAND:
			DoCommand( hwnd, wParam );
			break;
		}
	return( DefWindowProc( hwnd, message, wParam, lParam ) );
}

/***************************************************/
/* DoCommand													*/
/***************************************************/

void DoCommand( HWND hwnd, int id )
{
	switch( id )
		{
		case IDM_OPEN: {
			OPENFILENAME ofn;
			char sz[ 100 ];
			static char * szFilters[] = { "All Files (*.*)",
						"*.*", "" };

			sz[ 0 ] = '\0';
			ofn.lStructSize = sizeof( OPENFILENAME );
			ofn.hwndOwner = hwnd;
			ofn.hInstance = NULL;
			ofn.lpstrFilter = szFilters[ 0 ];
			ofn.lpstrCustomFilter = NULL;
			ofn.nMaxCustFilter = 0;
			ofn.nFilterIndex = 1;
			ofn.lpstrFile = sz;
			ofn.nMaxFile = sizeof( sz );
			ofn.lpstrFileTitle = NULL;
			ofn.nMaxFileTitle = 0;
			ofn.lpstrInitialDir = NULL;
			ofn.lpstrTitle = "Open File";
			ofn.Flags = OFN_HIDEREADONLY|OFN_PATHMUSTEXIST|
							OFN_FILEMUSTEXIST;
			ofn.nFileOffset = 0;
			ofn.nFileExtension = 0;
			ofn.lpstrDefExt = NULL;
			ofn.lCustData = 0;
			ofn.lpfnHook = NULL;
			ofn.lpTemplateName = 0;
			if( GetOpenFileName( &ofn ) )
				AddMRUItem( hwnd, sz );
			break;
			}

		case IDM_EXIT:
			SendMessage( hwnd, WM_CLOSE, 0, 0L );
			break;

		case IDM_FILE1:
		case IDM_FILE2:
		case IDM_FILE3:
		case IDM_FILE4:
		case IDM_FILE5:
		case IDM_FILE6: {
			char sz1[ 144 ];
			char sz2[ 144 ];

			GetMRUItem( id, sz1 );
			wsprintf( sz2, "File '%s' selected",
						(LPSTR)sz1 );
			MessageBox( hwnd, sz2, "Open", MB_OK|MB_ICONHAND );
			break;
			}
		}
}

