#include <windows.h>
#include <string.h>
#include <conio.h>

#ifndef INCL_DEVICE
    #define INCL_DEVICE
    #include "device.h"
#endif
#ifndef INCL_RING0ASM
    #define INCL_RING0ASM
    #include "ring0asm.h"
#endif

#define DEFAULT_BUFFER_SIZE   1024
#define ID_VPICD             0x03

DEVICEINFO  Com1 = { 0x3F8, 4 };
DEVICEINFO  Com2 = { 0x2F8, 3 };
DEVICEINFO  Com3 = { 0x1E0, 9 };
VOIDFARPROC pfn_VPICD_Entry;

void StartTx( PDEVICEINFO hPort );
BOOL Install_Ring0_Handler( PDEVICEINFO hPort );
VOID Remove_Ring0_Handler( PDEVICEINFO hPort );

#ifdef __BORLANDC__
    #pragma argsused
#endif        
int CALLBACK LibMain(HINSTANCE ModuleHandle_,
    WORD DataSegment, WORD HeapSize, LPSTR CommandLine)
    {
    if(HeapSize > 0)
        UnlockData(0);
    return 1;
    }

static  HWND DebugWindow = 0;
#ifdef __BORLANDC__
    #pragma argsused
#endif
int CALLBACK _export WEP(int ExitCode)
    {
    return 1;
    }

PDEVICEINFO far pascal _export Open( BYTE PortNumber, HWND hWindow )
{               
   DEVICEINFO  *hPort;
   HGLOBAL     hndl;
   BYTE        mask;

   if (PortNumber > 3)
      return( (PDEVICEINFO)ERR_BAD_PORT );
   if (PortNumber == 1)
      hPort = &Com1;
   else if (PortNumber == 2)
      hPort = &Com2;
   else
      hPort = &Com3;

   hPort->TxBuf.Size = DEFAULT_BUFFER_SIZE;
   hndl = GlobalAlloc( GMEM_FIXED, 
		       hPort->TxBuf.Size );
   if (NULL == hndl)
      return( (PDEVICEINFO)ERR_NO_MEM );
   hPort->TxBuf.Start = GlobalLock( hndl );
   hPort->TxBuf.In = hPort->TxBuf.Out = 0;

   /* Mask off interrupt at PIC. */
   if ( hPort->Irq < 8 )
   {
      mask = inp( MASTER_PIC_MASK );
      SET( mask, 1 << hPort->Irq );
      outp( MASTER_PIC_MASK, mask );
   }
   else
   {
      SET( hPort->Flags, FLAGS_ON_SLAVE_PIC );
      mask = inp( SLAVE_PIC_MASK );
      SET( mask, 1 << (hPort->Irq-8) );
      outp( SLAVE_PIC_MASK, mask );
   }

   if (!Install_Ring0_Handler( hPort ))
      return( (PDEVICEINFO)ERR_NOT_ENHANCED );

   /* Configure UART.   */
   outp( hPort->IoBase+UART_REG_IER, 0 );
   outp( hPort->IoBase+UART_REG_LCR, UART_LCR_DLAB );
   outp( hPort->IoBase+UART_REG_BAUDLO, BAUD_9600 );
   outp( hPort->IoBase+UART_REG_BAUDHI, 0 );
   outp( hPort->IoBase+UART_REG_LCR, UART_LCR_8N1 );
   outp( hPort->IoBase+UART_REG_MCR, UART_MCR_OUT2 );

   /* Unmask interrupt at PIC. */
   if ( hPort->Irq < 8 )
   {
      mask = inp( MASTER_PIC_MASK );
      CLR( mask, 1 << hPort->Irq );
      outp( MASTER_PIC_MASK, mask );
   }
   else
   {
      mask = inp( SLAVE_PIC_MASK );
      CLR( mask, (1 << (hPort->Irq-8)) );
      outp( SLAVE_PIC_MASK, mask );
   }

   hPort->Flags |= FLAGS_OPEN;
   hPort->id = PortNumber;
   hPort->hwnd = hWindow;

   return( hPort );
}

LONG far pascal _export Close(PDEVICEINFO volatile hPort)
{
   BYTE     mask;

   if ( !(hPort->Flags & FLAGS_OPEN) )
      return( ERR_NOT_OPEN );

   /* signal ISR to disable ints */
   hPort->Flags &= ~FLAGS_OPEN;
   /* wait for ISR to disable ints */
   while (!(hPort->Flags & FLAGS_CLOSE))
        ;

   outp( hPort->IoBase + UART_REG_IER, 0 );             
   outp( hPort->IoBase + UART_REG_MCR, 0 );             

   /* Mask off IRQ at PIC. */
   if (hPort->Irq < 8)
   {
      mask = inp( MASTER_PIC_MASK );
      SET( mask, 1 << hPort->Irq );
      outp( MASTER_PIC_MASK, mask );
   }
   else
   {
      SET( hPort->Flags, FLAGS_ON_SLAVE_PIC );
      mask = inp( SLAVE_PIC_MASK );
      SET( mask, 1 << (hPort->Irq-8) );
      outp( SLAVE_PIC_MASK, mask );
   }

   Remove_Ring0_Handler(hPort);
   
   /* Free buffer */
   GlobalFree( SELECTOROF( hPort->TxBuf.Start) );
   return TRUE;
}

LONG far pascal _export GenerateInts( PDEVICEINFO hPort )
{
   if (!(hPort->Flags & FLAGS_OPEN) )
      return( ERR_NOT_OPEN );
   memset( hPort->TxBuf.Start, '$', 
	   hPort->TxBuf.Size );
   StartTx( hPort );
   return( 0 );
}

LONG far pascal _export GetNumInts( PDEVICEINFO hPort )
{
   return( hPort->numInts );
}

void StartTx( PDEVICEINFO hPort )
{
   char  ier;
   WORD  IoBase = hPort->IoBase;

   if (! (UART_LSR_THRE & inp( IoBase+UART_REG_LSR )) )
     return;

   ier = inp( IoBase+UART_REG_IER );
   if (UART_IER_THRE & ier)
     return;

   outp( IoBase+UART_REG_IER, 
	 ier | UART_IER_THRE );
   
} 

BOOL Install_Ring0_Handler( PDEVICEINFO hPort )
{  
   WORD      sel;
   PRING0    pRing0;

   /* See if VPICD Ring0 services are available.    */
   /* AX = function code                            */
   /* BX = VPICD id                                 */
   /* returns with ES:DI -> VPICD entry point       */
   ASM   {
      xor  di, di
      mov  es, di
      mov  ax, 0x1684        
      mov  bx, ID_VPICD     
      int  0x2F
      mov  WORD PTR [pfn_VPICD_Entry], di
      mov  WORD PTR [pfn_VPICD_Entry+2], es
      mov  ax, es           
      or   ax, di
      jz   xit1         /* es:di = 0 means no VPICD */
      
      mov  ax, VPICD_Get_Version
      call [pfn_VPICD_Entry]
      cmp  ax, 0x30A
      jae  xit1
      mov  WORD PTR [pfn_VPICD_Entry], 0
      mov  WORD PTR [pfn_VPICD_Entry+2], 0
   }
xit1:

   /* Return FALSE if no Ring0 services */
   if (pfn_VPICD_Entry == NULL)
      return(FALSE);

   /* Fill in Ring0 structure   */
   pRing0 = &(hPort->Ring0Info);                  
   memset( pRing0, 0, sizeof( RING0 ) );
   pRing0->IrqNumber   = hPort->Irq;
   pRing0->IsrProc     = OFFSETOF(Asm_Ring0_Isr);
   pRing0->ControlProc = OFFSETOF(Asm_Ring0_Control);
   pRing0->Ring3Cs = SELECTOROF( Asm_Ring0_Isr ); 
   /* Extract DS from any far pointer which points to   */
   /* something in my data segment.                     */
   pRing0->Ring3Ds = SELECTOROF( hPort );   

   pRing0->DescrCount   = 1;
   sel = SELECTOROF( hPort->TxBuf.Start );
   pRing0->Descriptor[0].Ring3Sel = sel;
   
   /* Call VPICD to install our Ring0 handler   */
   /* AX = function code                        */
   /* ES:DI -> Ring0 structure                  */
   ASM   {
      mov   ax, VPICD_Install_Handler
      mov   di, WORD PTR pRing0
      push  ds
      pop   es
      call  [pfn_VPICD_Entry]
      jnc   xit2
      xor   ax, ax  /* failure, return 0        */
   }
xit2:                /* success                 */

   return( TRUE );
}  

VOID Remove_Ring0_Handler( PDEVICEINFO hPort )
{
   PRING0    pRing0;

   /* Call VPICD to remove our Ring0 handler    */
   /* AX = function code                        */
   /* ES:DI -> Ring0 structure                  */
   pRing0 = &(hPort->Ring0Info);                  
   ASM   {
      mov   ax, VPICD_Remove_Handler
      mov   di, WORD PTR pRing0
      push  ds
      pop   es
      call  [pfn_VPICD_Entry]
   }
}
