#ifdef __BORLANDC__
    #define ASM asm
#else
    #define ASM _asm
#endif

#define FLAGS_ON_SLAVE_PIC    0x01
#define FLAGS_OPEN            0x04
#define FLAGS_CLOSE           0x08
#define FLAGS_CALLBACK_OUTSTANDING  0x10

#define UART_REG_THR          0x00
#define UART_REG_IER          0x01
#define UART_REG_IIR          0x02
#define UART_REG_LCR          0x03
#define UART_REG_MCR          0x04
#define UART_REG_LSR          0x05
#define UART_REG_BAUDLO       0x00
#define UART_REG_BAUDHI       0x01

#define UART_IIR_NONE         0x01
#define UART_IIR_THRE         0x02
#define UART_IER_THRE         0x02
#define UART_MCR_OUT2         0x08
#define UART_LSR_THRE         0x20
#define UART_LSR_TSRE         0x40
#define UART_LCR_DLAB         0x80
#define UART_LCR_8N1          0x03
#define BAUD_9600             0x0C

#define MASTER_PIC_CTRL       0x20
#define MASTER_PIC_MASK       0x21
#define SLAVE_PIC_CTRL        0xA0
#define SLAVE_PIC_MASK        0xA1
#define EOI                   0x20

#define ERR_BAD_PORT 0xFFFFFFF1
#define ERR_NO_MEM   0xFFFFFFF2
#define ERR_NOT_OPEN 0xFFFFFFF3
#define ERR_NOT_ENHANCED 0XFFFFFFF4

#define VPICD_Get_Version     0x00
#define VPICD_Install_Handler 0x01
#define VPICD_Remove_Handler  0x02
#define VPICD_Call_At_Ring0   0x03

#define VPICD_API_EOI         0x00
#define VPICD_API_Mask        0x01
#define VPICD_API_Unmask      0x02
#define VPICD_API_Get_Mask    0x03
#define VPICD_API_Get_IIR     0x04
#define VPICD_API_Get_ISR     0x05
#define VPICD_API_Call_Back   0x06

#define SET( value, mask )    value |= mask
#define CLR( value, mask )    value &= (~mask)

#define MAKEP( seg, off ) ((void far *) MAKELONG( (off), (seg) ))

typedef void (FAR interrupt *VOIDINTPROC)();
typedef void (FAR PASCAL *VOIDFARPROC)();
typedef void (NEAR PASCAL *VOIDNEARPROC)();

typedef struct
{
   WORD   Ring3Sel;
   WORD   Ring3Off;
   WORD   Ring0Linear;
} DESCR;

typedef struct
{
   WORD     IrqNumber;
   WORD     VmId;
   DWORD    Next;
   DWORD    Reserved1;  /* hIRQStruc? */
   DWORD    Reserved2;
   DWORD    Reserved3;
   DWORD    Reserved4;
   DWORD    Flags;
   WORD     Mode;
   WORD     IsrProc;
   WORD     ControlProc;
   WORD     What;
   DWORD    Ring3API;
   DWORD    Ring0API;
   WORD     Ring3Cs;
   WORD     Ring3Ds;
   WORD     Ring0Cs;
   WORD     Ring0Ds;
   WORD     DescrCount;
   DESCR    Descriptor[1];   
} RING0, far * PRING0;

typedef struct
{
   char far *Start;     
   WORD     Size;
   WORD     In;
   WORD     Out;
} BUFINFO;

typedef struct
{
   WORD     IoBase;
   BYTE     Irq;
   BYTE     Flags;
   WORD     id;                                             
   HWND     hwnd;
   BUFINFO  TxBuf;
   void far *OldHandler;   
   DWORD    numInts;
   DWORD    numMsgs;
	// MUST be last field in DEVICEINFO
   RING0    Ring0Info;           
} DEVICEINFO, far * PDEVICEINFO;

extern DEVICEINFO  Com1;
extern DEVICEINFO  Com2;
extern DEVICEINFO  Com3;

PDEVICEINFO far pascal _export Open( BYTE PortNumber, HWND hWindow );
LONG far pascal _export Close( PDEVICEINFO hPort );
LONG far pascal _export GenerateInts( PDEVICEINFO hPort );
LONG far pascal _export GetNumInts( PDEVICEINFO hPort );













				    
