#include <dos.h>
#include <windows.h>
#include <stdarg.h>
#include <string.h>

#ifndef INCL_DEVICE
#define INCL_DEVICE
#include "device.h"
#endif

#define COM1 1
#define COM2 2

static PDEVICEINFO hPort;
static unsigned height;
static char szNumMsgs[ 20 ];

int hprintf (HDC hdc, int linenum, 
	     const char *fmt, ...)
{
   static   char s[256];
   int      len;
   va_list  marker;

   va_start( marker, fmt );
   TextOut( hdc, 0, linenum * height, 
	    s, len = wvsprintf( s, fmt, marker ));
   va_end( marker );

   return( len );
}

long FAR PASCAL _export WndProc( HWND hwnd, 
	WORD message, WORD wParam, LONG lParam )
{
   HDC          hdc;
   PAINTSTRUCT  ps;
   TEXTMETRIC   tm;
   DWORD        numInts;
   LPDWORD      plNumMsgs;
   static DWORD numTicks, intRate;
   static BOOL  fUserMsg = 0;
   static DWORD lNumMsgs;

   switch( message )
   {
   case WM_CREATE:
	hPort = Open( COM2, hwnd );
	if ((hPort == (PDEVICEINFO)ERR_BAD_PORT) || 
	    (hPort == (PDEVICEINFO)ERR_NO_MEM))
	{
	   MessageBox( hwnd, "Port not found", NULL, MB_OK | MB_ICONHAND );
	   PostQuitMessage( 0 );
	}
	else if (hPort == (PDEVICEINFO)ERR_NOT_ENHANCED)
	{
	   MessageBox( hwnd, "This program requires 386 Enhanced mode", NULL, MB_OK | MB_ICONHAND );
	   PostQuitMessage( 0 );
	}
	else
	{
	   GenerateInts( hPort );        
	   hdc = GetDC( hwnd );
	   GetTextMetrics( hdc, &tm );
	   height = tm.tmHeight + tm.tmExternalLeading;
	   ReleaseDC( hwnd, hdc );
	}
	return( 0 );

   case WM_DESTROY:
      Close( hPort );
      PostQuitMessage( 0 );
      return( 0 );

   case WM_TIMER:
      numTicks++;
      InvalidateRect( hwnd, NULL, FALSE ); 
      return( 0 );

   case WM_PAINT:
      hdc = BeginPaint( hwnd, &ps );
      if (numTicks)
      {
	 numInts = GetNumInts( hPort );
	 intRate = numInts / numTicks;
	 hprintf( hdc, 0, 
		  "Total interrupts serviced = %lu", 
		  numInts );
	 hprintf( hdc, 1, 
		  "Interrupt service rate = %lu/second", 
		  intRate );
      }
      if (fUserMsg)
      {
	 fUserMsg = 0;
	 hprintf( hdc, 4, "Message posted=%lu", lNumMsgs );
      }                               
      EndPaint( hwnd, &ps );  
      return( 0 );

   case WM_USER:
      fUserMsg = 1;
      plNumMsgs = (LPDWORD)lParam;
      lNumMsgs = *plNumMsgs;
      InvalidateRect( hwnd, NULL, FALSE ); 
      return( 0 );
			
   default:
      return( DefWindowProc( hwnd, message, wParam, lParam ) );

   }
}

int PASCAL WinMain( HANDLE hInstance,
		    HANDLE hPrevInstance,
		    LPSTR lpszCmdParam,
		    int nCmdShow )
{
   HWND         hwnd;
   MSG          msg;
   WNDCLASS     wndclass;

   if (!hPrevInstance)
   {
      wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNCLIENT;
      wndclass.lpfnWndProc = WndProc;
      wndclass.cbClsExtra   = 0;
      wndclass.cbWndExtra   = 0;
      wndclass.hInstance    = hInstance;
      wndclass.lpszMenuName = NULL;
      wndclass.lpszClassName = "IntMeter";
      wndclass.hIcon  =  LoadIcon( NULL, IDI_APPLICATION );
      wndclass.hCursor = LoadCursor( NULL, IDC_ARROW );
      wndclass.hbrBackground = GetStockObject( WHITE_BRUSH );

      RegisterClass( &wndclass );
   }

   hwnd = CreateWindow( "IntMeter",
			"INTMETER",
			WS_OVERLAPPEDWINDOW,
			CW_USEDEFAULT, CW_USEDEFAULT, 
			300, 150,
			NULL, NULL, hInstance, NULL );

   if (!SetTimer( hwnd, 1, 1000, NULL ))
   {
      MessageBox( GetFocus(),
		  "Too many Timers or Clocks!", 
		  "", 
		  MB_OK | MB_SYSTEMMODAL );
      return( FALSE );
   }

   ShowWindow( hwnd, nCmdShow );
   UpdateWindow( hwnd );

   
   while( GetMessage( &msg, NULL, 0, 0 ))
   {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
   }
      
   return( msg.wParam );
}
