include RING0.INC
include DEVICE.INC

DATA SEGMENT WORD PUBLIC 'DATA'
DATA ENDS

INTERRUPT SEGMENT WORD PUBLIC 'CODE'

EXTRN _C_Ring0_Isr:NEAR
EXTRN _C_Callback_Event:NEAR

ASSUME cs:INTERRUPT

public _Asm_Ring0_Isr
_Asm_Ring0_Isr proc far

	push	ds
	push	si
	push	ax
	push	bx
	push    cx
  	push	dx

	; VPICD calls this entry point with 
	; ES:DI pointing to our RING0 structure.
   ; Use this to get address of DEVICEINFO 
	; structure, since we located Ring0 
	; structure at the end of DEVICEINFO.
	mov		si, es
	mov		ds, si
	lea		si, [di-SIZE DeviceInfo]        

	push    di
   push    es

	; ds:si -> DeviceInfo
	call	_C_Ring0_Isr     

   pop     es
   pop     di
   pop     dx
   pop     cx

	pop		bx
	pop		ax
	pop		si
	pop		ds
	ret

_Asm_Ring0_Isr endp

public _Asm_Callback_Event
_Asm_Callback_Event proc far

	; VPICD calls this entry point with 
	; ES:DI pointing to our RING0 structure.
   ; Use this to get address of DEVICEINFO 
	; structure, since we located Ring0 
	; structure at the end of DEVICEINFO.
	mov		si, es
	mov		ds, si
	lea		si, [di-SIZE DeviceInfo]        

	; ds:si -> DeviceInfo
	call	_C_Callback_Event     

	ret

_Asm_Callback_Event endp

public _Asm_Ring0_Control
_Asm_Ring0_Control proc far
        ret
_Asm_Ring0_Control endp

INTERRUPT ENDS

END 
