#include <windows.h>
#include <conio.h>
#include "device.h"
#include "ring0asm.h"

#define USER_MESSAGE    WM_USER

DEVICEINFO   *hPort;
BYTE         iir, ier;
WORD         ixBuf;
WORD         selRing0;
BYTE far     *fpByte;
RING0        *pRing0;
VOIDFARPROC  pfApi;
VOIDFARPROC  pfCallback;
LPDWORD      pMsgInfo;

/*********************************
 Entry: DS = data segment
        SI -> port instance
        caller saves registers 
***********************************/

void C_Ring0_Isr( void )
{
   _asm mov hPort, si
   pfApi = (VOIDFARPROC)hPort->Ring0Info.Ring0API;
   pRing0 = &hPort->Ring0Info;

   while (UART_IIR_NONE != 
	 (iir = inp( hPort->IoBase+UART_REG_IIR )) )
   {
      hPort->numInts++;
      if (iir & UART_IIR_THRE)
      {
	 if (hPort->Flags & FLAGS_OPEN)  
	 {
	    selRing0 = hPort->Ring0Info.Descriptor[0].Ring0Linear;
	    ixBuf = hPort->TxBuf.Out;               
	    fpByte = MAKEP( selRing0, ixBuf );
	    outp( hPort->IoBase + UART_REG_THR, *fpByte );
	    ixBuf++;
	    if (ixBuf >= hPort->TxBuf.Size)
	       hPort->TxBuf.Out = 0;
	    else
	       hPort->TxBuf.Out = ixBuf;
	 }
	 else
	 {
	    // port closing, disable transmit interrupt
	    ier = inp( hPort->IoBase + UART_REG_IER );
	    outp( hPort->IoBase + UART_REG_IER, ier & (~UART_IER_THRE) );
	    hPort->Flags |= FLAGS_CLOSE;
	 }
      }         

      if ((hPort->numInts != 0) && 
	 ((hPort->numInts & 0x00000FFFL) == 0) && 
	 (!(hPort->Flags & FLAGS_CALLBACK_OUTSTANDING)) )
      {
	 // Call VPICD EOI service:
	 // AX = VPCID_API_AOI
	 // ES:DI -> Ring0 structure
	 SET(hPort->Flags, FLAGS_CALLBACK_OUTSTANDING);
	 hPort->numMsgs++;
	 pfCallback = (VOIDFARPROC)Asm_Callback_Event;
	 ASM {
	   mov  ax, VPICD_API_Call_Back
	   mov  bx, 1             // force SYS VM
	   // CX:DX -> callback function
	   // CX must be Ring3 Segment!!
	   mov  cx, WORD PTR pfCallback+2  
	   mov  dx, WORD PTR pfCallback
	   mov  si, 1             // low priority boost
	   push ds
	   pop  es
	   mov  di, pRing0                  
	   call pfApi
	}
     }
   }                          

   hPort->Ring0Info.Mode = 0;
   ASM   {
      // Call VPICD EOI service:
      // AX = VPCID_API_AOI
      // ES:DI -> Ring0 structure
      xor  ax, ax                              
      push ds
      pop  es
      mov  di, pRing0                  
      call pfApi
      // make sure compiler doesn't touch 
      // Carry flag between CLC and RET
      clc                             
   }
}

//*********************************
// Entry: DS = data segment
//        SI -> port instance
//        caller saves registers 
//**********************************
void C_Callback_Event( void )
{
   ASM mov hPort, si
   CLR(hPort->Flags, 
       FLAGS_CALLBACK_OUTSTANDING);
   pMsgInfo = &(hPort->numMsgs);
   PostMessage( hPort->hwnd, 
		USER_MESSAGE, 
		hPort->id, 
		(LPARAM)pMsgInfo );
}
