/* Listing 3 : MONODLL.C  */

#include <windows.h>
#include "monodll.h"

extern WORD _B000H;

#define CPL 80      /* Characters Per Line              */
#define LPP 25      /* Lines Per Page                   */
#define ATTR 0x700  /* video attribute, white on black  */

unsigned int monitorOff = 0;    /* library on/off       */
unsigned int far *screen;       /* pointer to B000      */
unsigned int currentLine = 0;   /* current line         */
unsigned int currentChar = 0;   /* current char         */

void incrementline( void )
{
/*  This is a local routine.  It increments the
    current line pointer and performs the scroll
    function if required. */
    
    int i;
    currentChar = 0;
    currentLine++;
    /* scroll the screen if required */
    if ( currentLine == LPP ) {
        /* move lines 2 thru 25 up one line */
        for ( i = CPL; i < (CPL*LPP); i++)
            screen[i-CPL] = screen[i];
        /* clear last line */
        for ( i = CPL*(LPP-1); i < (CPL*LPP);i++ ) 
            screen[i] = ATTR + ' ';
        /* decrement current line pointer */
        currentLine -= 1;
    }
}

void clearscreen( void )
/* This is a local routine used to clear the
    screen and reposition the pointers */
{
    int i;
    for ( i = 0; i < (CPL*LPP); i++ )
         screen[i] = ATTR + ' ';
    currentLine = 0;
    currentChar = 0;
}

void far PASCAL _export mprint(int newLine,
                                          char far *message)
{
/*  This function will display a string on the
    secondary monitor and generate a CR/LF if
    requested. Wrapping is supported and any
    string that extends past column 79 is wrapped
    around.  Scrolling is also supported once line
    25 is written to. */

    int i;
    static firstTimeThru = 1;   /* used to clear the screen
                                 * the first time in      */
    if ( monitorOff ) return;
    if ( firstTimeThru ) {
        firstTimeThru = 0;
        /* use a predefined global selector
           to access the B&W video memory */
        screen = (unsigned int far *) MAKELONG(0, &_B000H);
        clearscreen();
    }
    /* send out the message  */
    i = 0;
    while ( message[i] != 0 ) {
        /* check for word or character wrap */
        if ( currentChar == CPL )
            incrementline();
        screen[(CPL*currentLine)+currentChar++] =
            ATTR + message[i++];
    }
    /* check on newline generation */
    if (newLine == 1)
        incrementline();
}

void far PASCAL _export monooff( unsigned int state )
/* Turn on/off access to the monitor. */
{
   monitorOff = state;
}

#ifdef __BORLANDC__
    #pragma argsused
#endif
int far PASCAL LibMain( HANDLE hInstance, WORD wDataSeg,
                        WORD wHeapSize, LPSTR lpszCmdLine )
/* Required by Windows, this is an empty shell. */
{
    /* The startup code for the DLL initializes the
        local heap (if there is one) with a call to
        LocalInit which locks the data segment. */
    if ( wHeapSize != 0 )
        UnlockData( 0 );
    return 1;
}

void far PASCAL WEP( int nExitType )
/* Required by Windows, this is an empty shell. */
{
    switch( nExitType )
    {
    case WEP_SYSTEM_EXIT:
        return;
    case WEP_FREE_DLL:
        return;
    default:
        return;
    }
}
// End of File: MONODLL.C

