/* Listing 1 : MONODOS.C */

#include "monodos.h"
#include <dos.h>        /* for MK_FP                */
#include <stdio.h>      /* for vsprintf             */
#include <stdarg.h>     /* for variable parameters  */

#define MONOBUFSIZE 256 /* variable parameter 
                                    buffer size     */
#define CPL 80          /* Characters Per Line      */
#define LPP 25          /* Lines Per Page           */
#define ATTR 0x700      /* video attribute, 
                                    white on black  */

unsigned int monitorOff = 0;    /* library on/off   */
unsigned int far *screen;       /* pointer to B000  */
unsigned int currentLine = 0;   /* current line     */
unsigned int currentChar = 0;   /* current char     */

void incrementline( void )
{
/*  This is a local routine.  It increments the     *
 *  current line pointer and performs the scroll    *
 *  function if required.                           */
    
    int i;
    currentChar = 0;
    currentLine++;
    /* scroll the screen if required */
    if ( currentLine == LPP ) {
        /* move lines 2 thru 25 up one line */
        for ( i = CPL; i < (CPL*LPP); i++)
            screen[i-CPL] = screen[i];
        /* clear last line */
        for ( i = CPL*(LPP-1); i < (CPL*LPP);i++ )
            screen[i] = ATTR + ' ';
        /* decrement current line pointer */
        currentLine -= 1;
    }
}

void clearscreen( void )
/* This is a local routine used to clear the
    screen and reposition the pointers       */
{
    int i;
    for ( i = 0; i < (CPL*LPP); i++ ) {
         screen[i] = ATTR + ' ';
    }
    currentLine = 0;
    currentChar = 0;
}

void mprint( int newLine, char far *message )
{
/* This function will display a string on the
    secondary monitor and generate a CR/LF if
    requested. Wrapping is supported and any
    string that extends past column 79 is wrapped
    around.  Scrolling is also supported once line
    25 is written to. */
 
    int i;
    static firstTimeThru = 1;   /* used to clear the screen
                                            first time in */
    if ( monitorOff ) return;
    if ( firstTimeThru ) {
        firstTimeThru = 0;
        screen = (unsigned int far*)
            MK_FP( 0xB000, 0 );
        clearscreen();
    }
    /* send out the message  */
    i = 0;
    while ( message[i] != 0 ) {
        /* check for word or character wrap */
        if ( currentChar == CPL ) {
            incrementline();
        }
        screen[(CPL*currentLine)+currentChar++] =
            ATTR + message[i++];
    }

    /* check on newline generation */
    if (newLine == 1) {
        incrementline();
    }
}

void mprintf( int newLine, char far *format, ...)
{
/*    This function displays a formatted string on
    the secondary monitor. */

    va_list argptr;
    char buf[MONOBUFSIZE];

    va_start( argptr, format );
    vsprintf( buf, format, argptr );
    va_end( argptr );

    mprint( newLine, buf );
}

void monooff( unsigned int state )
/* Turn on/off access to the monitor. */
{
   monitorOff = state;
}

/* End of File: MONODOS.C  */

