/* -- Demonstrate use of LockWindowInput() and       */
/*    SelectVisRgn().                                */
/* -- compile with "cc lockdemo.c".                  */

#include <windows.h>

char    szApp[]     = "LockDemo";

/* Exports. */
LRESULT CALLBACK _export LWndProc(HWND,UINT,WPARAM,LPARAM);
/* Imports. */
int WINAPI SelectVisRgn(HDC, HRGN);

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hinsThis, HINSTANCE hinsPrev,
                          LPSTR lszCommand, int wShowWindow)
    {
    HWND    hwnd;           /* Main window. */
    MSG     msg;            /* For message pump. */

    if (!hinsPrev)  /* Register classes first time. */
        {
        WNDCLASS    wcs; 

        wcs.style = CS_HREDRAW | CS_VREDRAW;
        wcs.lpfnWndProc = LWndProc;
        wcs.cbClsExtra = 0; 
        wcs.cbWndExtra = 0; 
        wcs.hInstance = hinsThis;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wcs.lpszMenuName = NULL;
        wcs.lpszClassName = szApp;
        if (!RegisterClass(&wcs))
            return 0;
        }

    /* Create and show the main window. */
    msg.wParam = 0;
    if ((hwnd = CreateWindow(szApp, szApp,
      WS_OVERLAPPEDWINDOW, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      NULL, NULL, hinsThis, NULL)) != NULL)
        {
        ShowWindow(hwnd, wShowWindow);
        UpdateWindow(hwnd);
        while (GetMessage(&msg, NULL, NULL, NULL)) 
            {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
            }
        }
    return msg.wParam;
    }

LRESULT CALLBACK _export LWndProc(HWND hwnd, UINT wm,
                               WPARAM wParam, LPARAM lParam)
    {
    static  HRGN    hrgn;   /* For entire desktop. */
    static  HDC     hdcDesk;    /* Desktop DC. */
    static  POINT   ptAnchor;   /* Mouse down point. */
    static  POINT   ptLast; /* Previous endpoint. */
    static  int     wDrawModeSav;

    switch (wm)
        {
    default:
        break;
    case WM_CREATE:
        if ((hrgn = CreateRectRgn(0, 0,
          GetSystemMetrics(SM_CXSCREEN),
          GetSystemMetrics(SM_CYSCREEN))) == NULL)
            return -1;
        break;
    case WM_DESTROY:
        if (hrgn)
            DeleteObject(hrgn);
        PostQuitMessage(0);
        break;
    case WM_LBUTTONDOWN:
        if ((hdcDesk = GetDC(NULL)) == NULL)
            break;
        GetCursorPos(&ptAnchor);
        ptLast = ptAnchor;
        SetCapture(hwnd);
        wDrawModeSav = SetROP2(hdcDesk, R2_NOT);
        LockWindowUpdate(GetDesktopWindow());
        SelectVisRgn(hdcDesk, hrgn);
        break;
    case WM_LBUTTONUP:
        if (GetCapture() != hwnd)
            break;
        /* Erase last line. */
        MoveToEx(hdcDesk, ptAnchor.x, ptAnchor.y,
          NULL);
        LineTo(hdcDesk, ptLast.x, ptLast.y);

        /* Return to normal. */
        LockWindowUpdate(NULL);
        ReleaseCapture();
        SetROP2(hdcDesk, wDrawModeSav);
        if (hdcDesk)
            ReleaseDC(NULL, hdcDesk);
        break;
    case WM_MOUSEMOVE:
        {
        POINT   pt;

        if (GetCapture() != hwnd)
            break;
        /* Erase previous line. */
        MoveToEx(hdcDesk, ptAnchor.x, ptAnchor.y,
          NULL);
        LineTo(hdcDesk, ptLast.x, ptLast.y);

        /* Draw new line. */
        GetCursorPos(&pt);
        MoveToEx(hdcDesk, ptAnchor.x, ptAnchor.y,
          NULL);
        LineTo(hdcDesk, pt.x, pt.y);
        ptLast = pt;
        }
        break;
        }   /* End switch wm. */
    return DefWindowProc(hwnd, wm, wParam, lParam);
    }
