/*****************************************************/
/* peektest.c                                        */
/* -- Test app message delivery during tight         */
/*      PeekMessage() loop.                          */
/* -- To build:                                      */
/*      cc peektest.c                                */
/*****************************************************/

#include <windows.h>
#include <windowsx.h>
#include "peektest.h"

LRESULT    CALLBACK _export LWndProc(HWND, UINT, WPARAM,
                                   LPARAM);
void    WakeSiblings(UINT, HWND);

char    szApp[]    = "PeekTest";
char    szMsg[80];

BOOL    fPosting, fReply;
UINT    wmWake, wmReply;

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(HINSTANCE hins, HINSTANCE hinsPrev,
                                       LPSTR lsz, int wShow)
    {
    MSG     msg;    /* A message from the queue. */
    HWND    hwnd;   /* Main window handle. */
    char    sz[80]; /* Main window title bar. */
    UINT    cmsg    = 0;    /* # PeekMessage calls. */

    if (!hinsPrev)
        {   /* Same old same old. */
        WNDCLASS    wcs;

        wcs.style = 0;
        wcs.lpfnWndProc = LWndProc;
        wcs.cbClsExtra = 0;
        wcs.cbWndExtra = 0;
        wcs.hInstance = hins;
        wcs.hIcon = LoadIcon(NULL, IDI_APPLICATION);
        wcs.hCursor = LoadCursor(NULL, IDC_ARROW);
        wcs.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
        wcs.lpszMenuName = MAKEINTRESOURCE(mnuStart);
        wcs.lpszClassName = szApp;

        if (!RegisterClass(&wcs))
            return FALSE;
        }

    /* Communicate with siblings using registered */
    /* messages to avoid having other apps listen in. */
    wmWake = RegisterWindowMessage(szApp);
    wmReply = RegisterWindowMessage("PeekTestReply");

    /* Create the main window. */
    if ((hwnd = CreateWindow(szApp, szApp,
      WS_OVERLAPPEDWINDOW, CW_USEDEFAULT,
      CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      NULL, NULL, hins, NULL)) == NULL)
        return 0;

    /* Display the window handle in the title so we */
    /* can tell sibling apps apart. */
    wsprintf(sz, "%s - %x", (LPSTR)szApp, hwnd);
    SetWindowText(hwnd, sz);
    ShowWindow(hwnd, wShow);
    for (;;)
        {
        /* Post a message to a sibling (maybe). */
        WakeSiblings(cmsg++, hwnd);

        /* See if we have a message, tight loop if */
        /* not. */
        if (!PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
            continue;

        if (msg.message == WM_QUIT)
            break;

        TranslateMessage(&msg);
        DispatchMessage(&msg);
        }

    return msg.wParam;
    }

LRESULT  CALLBACK _export LWndProc(HWND hwnd, UINT wm,
                               WPARAM wParam, LPARAM lParam)
    {
    /* First look for registered messages.  We can't */
    /* use them as cases in the switch statement     */
    /* they are generated on the fly so they aren't  */
    /* constants.                                    */

    /* If we received a wake-up message from a       */
    /* sibling (i.e. not from this task)), send back */
    /* a reply.  This allows the poster to see if we */
    /* ran when it called PeekMessage().             */
    if (wm == wmWake && (HWND)wParam != hwnd)
        {
        /* Acknowledge receipt. */
        SendMessage((HWND)wParam, wmReply,
          (WPARAM)hwnd, 0);

        /* Show message. */
        wsprintf(szMsg, "Received from %x at %ld",
          wParam, GetTickCount());
        InvalidateRect(hwnd, NULL, TRUE);
        UpdateWindow(hwnd);
        }
    else if (wm == wmReply)
        {
        /* We received a reply from a posted wake-up */
        /* message.  Record the fact. */
        fReply = TRUE;
        }
    else switch (wm)
        {
    default:
        break;
    case WM_DESTROY:
        PostQuitMessage(0);
        break;
    case WM_COMMAND:
        {
        UINT    mnu;

        if (wParam != idmPost)
            break;

        /* Toggle the "posting" state and change the */
        /* text of the menu bar to exit the new */
        /* mode. */
        mnu = (fPosting ^= TRUE) ? mnuStop : mnuStart;
        DestroyMenu(GetMenu(hwnd));
        SetMenu(hwnd, LoadMenu(GetWindowInstance(hwnd),
          MAKEINTRESOURCE(mnu)));
        DrawMenuBar(hwnd);
        }
        break;
    case WM_PAINT:  /* Display the message buffer. */
        {
        PAINTSTRUCT wps;
        RECT        rect;

        BeginPaint(hwnd, &wps);
        GetClientRect(hwnd, &rect);
        DrawText(wps.hdc, szMsg, -1, &rect,
          DT_WORDBREAK);
        EndPaint(hwnd, &wps);
        }
        break;
        }
    return DefWindowProc(hwnd, wm, wParam, lParam);
    }

void WakeSiblings(UINT cmsg, HWND hwnd)
/*****************************************************/
/* -- Broadcast a wake message to all top level      */
/*    windows once every 0x4000 calls.  Only other   */
/*    instances of this app will know what it means  */
/*    since we use a registered message.             */
/* -- cmsg    : Number of times this routine has     */
/*              been called.                         */
/* -- hwnd    : Main window.                         */
/*****************************************************/
    {
    MSG    msg;

    /* Only post the wake-up message if we are in */
    /* "posting" mode and only once every 0x4000 */
    /* times.  (This value works well on my machine, */
    /* your mileage may vary). */
    if (!fPosting || (cmsg & 0x3fff) != 0)
        return;

    PostMessage(HWND_BROADCAST, wmWake, (WPARAM)hwnd,
      0);

    /* This call to PeekMessage() should yield to */
    /* any other app with input in its queue, even */
    /* though we now have a wmWake in ours, since we */
    /* are filtering a message range not in our */
    /* queue.  If we yield to another instance of */
    /* this app, it will display a message in its */
    /* client area and send us a reply which will */
    /* set the acknowledged flag. */
    fReply = FALSE;
    PeekMessage(&msg, NULL, 0, 0,
      PM_NOREMOVE);
    if (fReply)
        {
        lstrcpy(szMsg, "Acknowledgement received");
        InvalidateRect(hwnd, NULL, TRUE);
        UpdateWindow(hwnd);
        }
    }
