//-----------------------------------------------
// CTIMER.H - Header file for CTimer class
//-----------------------------------------------

#ifndef	__CTIMER_FILE__
#define __CTIMER_FILE__

class CTimer
{

private:	// Accessible only to this class
	static UINT	pm_manyTimers;		// Number of timers in existance
	static UINT	pm_nextTimerID;		// Used to generate timer ID's
    UINT		m_IdCTimer;			// Unique ID for each timer
    DWORD		m_dwEventID;		// Unique ID for each event
			
protected:	// Accessible only to this class and derived classes
	BOOL		m_bRunning;			// TRUE if a timer is running
	DWORD		m_dwStartTime;		// Time timer was started
	DWORD		m_dwStopTime;		// Time timer was stopped
    UINT		m_minRes;			// Min. supported resolution
    
public:	// Accessible to everybody
	CTimer();						// Constructor
	~CTimer();						// Destructor
	
	//-----------------------------------------------------------------
	// The functions below deal with the event section of a CTimer.
	// EventOneShot() and EventPeriodic are overloaded to accept
	// either a message or a callback function as a parameter.
	//-----------------------------------------------------------------
	BOOL	InEvent();				// True if currently in a event
	BOOL	_inline CancelEvent();	// True if event was canceled

	BOOL	EventOneShot(UINT, FARPROC, DWORD =0L);		// OneShot (single) events overloaded
	BOOL	EventOneShot(UINT, HWND, UINT, DWORD =0L);	// for callbacks and messages
	BOOL	EventPeriodic(UINT, FARPROC, DWORD =0L);	// Periodic (multiple) events overloaded
	BOOL	EventPeriodic(UINT, HWND, UINT, DWORD =0L);	// for callbacks and messages


	//-----------------------------------------------------------------
	// The functions below deal with the timing (stopwatch) behavior of
	// a CTimer. They are all fairly basic and are inlined.
	//-----------------------------------------------------------------
	void	Start(){ m_bRunning=TRUE; m_dwStartTime=timeGetTime();};	// Starts a timer
	void	Stop(){ m_bRunning=FALSE; m_dwStopTime=timeGetTime();};		// Stops a timer
	void	Continue(){ m_bRunning=TRUE;};          					// Keep the timer running
	void	Reset(){ m_bRunning=FALSE; m_dwStartTime=0L; m_dwStopTime=0L;};	// Reset to initial values
	BOOL	IsRunning(){ return m_bRunning;};							// Is a timer running??
	DWORD	StartTime(){ return m_dwStartTime;};						// Time started (in ticks)
	DWORD	StopTime(){ return m_dwStopTime;};							// Time stoped (in ticks)
			
	// Reads a timer. The way in which the timer is read depends on if it is running or not.
	DWORD	Read(){ return (m_bRunning) ? timeGetTime()-m_dwStartTime : m_dwStopTime-m_dwStartTime;};
};

#endif // __CTIMER_FILE__
