/****************************************************************************
// Generic.CPP - Main application and implementation of the
// main dialog box. Serves as a host for other dialogs.
****************************************************************************/
#ifndef STRICT
#define STRICT
#endif

#include <afxwin.h>
#include <afxext.h>
#include <mmsystem.h>
#include "resource.h"
#include "resrc1.h"
#include "ctimer.h"
#include "timerdlg.h"
#include "ticker.h"
#include "supert.h"
#include "generic.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//------------------ Create the application. This will run it too --------------
CGenericApp NEAR ThisApp;


//-------- Create the dialog box and assign a icon to the program ---------
BOOL CGenericApp::InitInstance()
{
	m_pMainWnd = new CMainDlgWindow();
	SetClassWord(m_pMainWnd->m_hWnd,GCW_HICON, (WORD)LoadIcon(AFX_IDI_STD_FRAME));
	return TRUE;
}

//---- Create main window from dialog box template ----
CMainDlgWindow::CMainDlgWindow()
{
	Create(MAIN_DLG_WINDOW);                // Create the Dialog Window
}

//---- Called to initialize the dialog box ----
BOOL CMainDlgWindow::OnInitDialog()
{
	CDialog::OnInitDialog();                // Call base class first

	//-- We need to be in enhanced mode on a Win 3.1 system --
	//-- to use the 64-bit timer routines. Check and disable --
	//-- the button and menu item if we don't qualify. --
	if(!(GetWinFlags() & WF_ENHANCED) ||
		(LOWORD(GetVersion()) < 0x0A03))
	{
		GetDlgItem(IDC_SUPERTIME)->EnableWindow(FALSE);
		GetMenu()->EnableMenuItem(ID_OPTIONS_SUPERTIME, MF_GRAYED);
	}
		
return TRUE;
}

//--------- Exit picked from the menu ----------
void CMainDlgWindow::OnExit()
{
	OnClose();                                              // Do the OnClose member function
}

//--------- The application is ending --------
void CMainDlgWindow::OnClose()
{
	DestroyWindow();                                // Destroy the dialog box window
	delete this;                                    // Delete 'this' dialog box object
	PostQuitMessage(0);                             // End the application
}

//-------------------------------------------------
// Message map for the application. Borland users
// may feel a bit uncomfortable here. It basically
// routes messages to certain handlers in what some
// call a object oriented way.
//-------------------------------------------------
BEGIN_MESSAGE_MAP(CMainDlgWindow, CDialog)
	//{{AFX_MSG_MAP(CMainDlgWindow)
	ON_WM_CLOSE()
	ON_COMMAND(ID_ABOUT, OnAbout)
	ON_COMMAND(ID_EXIT, OnExit)
	ON_COMMAND(ID_OPTIONS_NEWTIMER, OnNewTimer)
	ON_COMMAND(ID_OPTIONS_TICKTEST, OnTickTest)
	ON_COMMAND(ID_OPTIONS_SUPERTIME, OnSuperTime)
	ON_BN_CLICKED(IDC_NEWTIMER, OnNewTimer)
	ON_BN_CLICKED(IDC_TICKTEST, OnTickTest)
	ON_BN_CLICKED(IDC_SUPERTIME, OnSuperTime)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

//-------- This is called when someone picks 'About' from the menu ---------
void CMainDlgWindow::OnAbout()
{
	CModalDialog aboutdlg(ABOUT_DLG_BOX, this);
	aboutdlg.DoModal();
}

//------------------------------------------------------------------
// This is called when someone either picks 'New Timer' from the menu
// or when they click the 'New Timer' button. Either way it will just
// create a modeless TimerDialog box with the parent being "this".
//------------------------------------------------------------------
void CMainDlgWindow::OnNewTimer()
{
	new     TimerDlg(this);
}

//------------------------------------------------------------------
// The next two dialog boxes are for the 'Tick Test' and the 64-bit
// timer. They are modal dialogs. No reason why, just a tradition.
//------------------------------------------------------------------
void CMainDlgWindow::OnTickTest()
{
	CTicker myTicker(this);
	myTicker.DoModal();     
}

void CMainDlgWindow::OnSuperTime()
{
	CSuperT mySuperT(this);
	mySuperT.DoModal();     
}
