// supert.cpp : implementation file
//
#ifndef STRICT
#define STRICT
#endif

#include <afxwin.h>
#include <afxext.h>
#include <mmsystem.h>
#include "resource.h"
#include "resrc1.h"
#include "supert.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

FARPROC lpfnVTD=0L;                     // Address of entry point to the VTD


/////////////////////////////////////////////////////////////////////////////
// CSuperT dialog

CSuperT::CSuperT(CWnd* pParent /*=NULL*/)
	: CDialog(IDD_SUPERTIME, pParent)
{
}

BEGIN_MESSAGE_MAP(CSuperT, CDialog)
	//{{AFX_MSG_MAP(CSuperT)
	ON_BN_CLICKED(IDC_ADDRESS, OnClickedAddress)
	ON_BN_CLICKED(IDC_TIME, OnClickedTime)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSuperT message handlers

void CSuperT::OnClickedAddress()
{
char    buff[64];

_asm{   
	mov     ax, 1684h               ; Load AX
	mov     bx, 5                   ; Load BX
	
	int     2fh;                    ; Try to get address of the VTD
	
	mov WORD PTR lpfnVTD[2], es     ; Return address is stored in ES:DI.
	mov WORD PTR lpfnVTD[0], di     ; Copy it into lpfnVTD for storage.

}       // End of ASM

	sprintf(buff, "VTD Address= %lp\n", lpfnVTD);           // Format the string
	GetDlgItem(IDC_ADDRESS_TEXT)->SetWindowText(buff);      // Set the window text
	GetDlgItem(IDC_TIME)->EnableWindow(TRUE);                       // Enable the 'TIME' button
}

void CSuperT::OnClickedTime()
{
DWORD   dwHigh, dwLow;
char    buff[64];

_asm{

	mov ax, 0100h   ; Prepare for VTD_GetRealTime
	call lpfnVTD    ; Call the VTD entry point
	
	_emit 0x66               ; The '_emit 0x66' instruction
	mov WORD PTR dwHigh, dx  ; converts these opcodes into:
	_emit 0x66               ;   mov DWORD PTR, EDX
	mov WORD PTR dwLow, ax   ;   mov DWORD PTR, EAX

}       // End of ASM

    sprintf(buff, "%08lx:%08lx\n", dwHigh, dwLow);          // Format the string
    GetDlgItem(IDC_TIME_TEXT)->SetWindowText(buff);         // Set the window text
}
