// ticker.cpp : implementation file
//
#ifndef STRICT
#define STRICT
#endif

#include <afxwin.h>
#include <afxext.h>
#include <mmsystem.h>
#include "resource.h"
#include "resrc1.h"
#include "ctimer.h"
#include "generic.h"
#include "ticker.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//-----------------------------------------------------
// Constructor will call the base class constructor.
//-----------------------------------------------------
CTicker::CTicker(CWnd* pParent)
	: CDialog(IDD_TICKER, pParent)
{
}

//-----------------------------------------------------
// A simple message map.
//-----------------------------------------------------
BEGIN_MESSAGE_MAP(CTicker, CDialog)
	//{{AFX_MSG_MAP(CTicker)
	ON_BN_CLICKED(IDC_UPDATE, OnClickedUpdate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


//-----------------------------------------------------
// Initialize the dialog box when it is first created.
//-----------------------------------------------------
BOOL CTicker::OnInitDialog()
{
char    buff[64];

	CDialog::OnInitDialog();

	myTimer.Start();                                // Start my timer
	m_dwIniCount=::GetTickCount();  // Get initial tick count
	

	wsprintf(buff, "%ld", m_dwIniCount);
	GetDlgItem(IDC_TICKSTART)->SetWindowText(buff);

	GetDlgItem(IDC_TIMERSTART)->SetWindowText("0"); // CTimer starts at T=0

	
	OnClickedUpdate();              // Force a update of the timer
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

//----------------------------------------------------------------
// Update the dialog box when someone presses the 'Update' button.
//----------------------------------------------------------------
void CTicker::OnClickedUpdate()
{
char    buff[64];
DWORD   dwTicksNow;
DWORD   dwTimerNow;
	
	dwTicksNow=::GetTickCount();
	dwTimerNow=myTimer.Read();
	
	wsprintf(buff, "%ld", dwTicksNow);
	GetDlgItem(IDC_TICKNOW)->SetWindowText(buff);

	wsprintf(buff, "%ld", dwTimerNow);
	GetDlgItem(IDC_TIMERNOW)->SetWindowText(buff);


	wsprintf(buff, "%ld", dwTicksNow-m_dwIniCount);
	GetDlgItem(IDC_TICKELAPSED)->SetWindowText(buff);
	
	wsprintf(buff, "%ld", dwTimerNow);
	GetDlgItem(IDC_TIMERELAPSED)->SetWindowText(buff);

	if(dwTimerNow > (dwTicksNow-m_dwIniCount))
		wsprintf(buff, "%ld", dwTimerNow-(dwTicksNow-m_dwIniCount));
	else
		wsprintf(buff, "%ld", (dwTicksNow-m_dwIniCount)-dwTimerNow);

	GetDlgItem(IDC_DELTA)->SetWindowText(buff);
}

