// timerdlg.cpp : implementation file

#ifndef STRICT
#define STRICT
#endif

#include <afxwin.h>
#include <afxext.h>
#include <mmsystem.h>
#include "resource.h"
#include "resrc1.h"
#include "ctimer.h"
#include "timerdlg.h"

#define         WM_ONESHOT              WM_USER+5
#define         WM_PERIODIC             WM_USER+6

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//------------ TimerDlg dialog routines -------------------

TimerDlg::TimerDlg(CWnd* pParent)
	: CDialog(IDD_CTIMER, pParent)
{
	Create(IDD_CTIMER, pParent);
}

TimerDlg::~TimerDlg()
{
}

void TimerDlg::OnDestroy()
{
	CDialog::OnDestroy();
	delete this;                    // Delete 'this' dialog box object
}

void TimerDlg::OnCancel()
{
	DestroyWindow();
}



BOOL TimerDlg::OnInitDialog()
{
int     i;
char    buff[64];

	//--------- Set window title with a proper timer number ------
	i=0;
	while(1){
		wsprintf(buff, "CTimer #%d", ++i);
		if(!FindWindow(NULL, buff))
		{
			SetWindowText(buff);
			break;
		}
	}
	
	GetDlgItem(IDC_TIMERSTOP)->EnableWindow(FALSE);         // Disable the STOP button
	GetDlgItem(IDC_TIMERCONT)->EnableWindow(FALSE);         // Disable the CONTINUE button

	CDialog::OnInitDialog();
	return TRUE;
}



BEGIN_MESSAGE_MAP(TimerDlg, CDialog)
	//{{AFX_MSG_MAP(TimerDlg)
	ON_BN_CLICKED(IDC_EVENTCANCEL, OnClickedEventcancel)
	ON_BN_CLICKED(IDC_EVENTLISTCLEAR, OnClickedEventlistclear)
	ON_BN_CLICKED(IDC_EVENTONESHOT, OnClickedEventoneshot)
	ON_BN_CLICKED(IDC_EVENTPERIODIC, OnClickedEventperiodic)
	ON_BN_CLICKED(IDC_INEVENT, OnClickedInevent)
	ON_BN_CLICKED(IDC_TIMERCONT, OnClickedTimercont)
	ON_BN_CLICKED(IDC_TIMERLISTCLEAR, OnClickedTimerlistclear)
	ON_BN_CLICKED(IDC_TIMERREAD, OnClickedTimerread)
	ON_BN_CLICKED(IDC_TIMERRESET, OnClickedTimerreset)
	ON_BN_CLICKED(IDC_TIMERRUNNING, OnClickedTimerrunning)
	ON_BN_CLICKED(IDC_TIMERSTART, OnClickedTimerstart)
	ON_BN_CLICKED(IDC_TIMERSTOP, OnClickedTimerstop)
	ON_WM_DESTROY()
	ON_MESSAGE(WM_PERIODIC, OnPeriodicMessage)
	ON_MESSAGE(WM_ONESHOT, OnOneShotMessage)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


//---------------- Event Handler Section -----------------
void    TimerDlg::SetGranularity()
{
int             delay;
double  freq;

	delay=GetDelay();               // Get the delay time in mSecs
		
	if(! delay)                             // Make sure it's at least one so we don't
		delay++;                        // get a "divide by zero" error
	
	freq= 1000.0 / (double) delay;  // Find the frequeny in hertz
	m_iGranularity = (UINT) (freq / 2.0);   // Twice per second is fine
		
	if(! m_iGranularity)    // Make sure it's at least one so we don't
		m_iGranularity++;       // get a "divide by zero" error

	m_iMany=0;                              // Clear the event counter
	
return;
}


void TimerDlg::OnClickedEventoneshot()
{
UINT    delay;

	if(!(delay=GetDelay()))
		return;
		
	if(globalTimer.EventOneShot(delay, m_hWnd, WM_ONESHOT))
		EventStatus("1-Shot event started");
	else
		EventStatus("1-Shot event failed");
}


void TimerDlg::OnClickedEventperiodic()
{
UINT    delay;

	if(!(delay=GetDelay()))
		return;

	SetGranularity();               // Set proper granularity for 2 updates / second

	if(globalTimer.EventPeriodic(delay, m_hWnd, WM_PERIODIC))
		EventStatus("Periodic event started");
	else
		EventStatus("Periodic event failed");
}


void TimerDlg::OnClickedEventcancel()
{
	if(globalTimer.CancelEvent())
		EventStatus("Event canceled");
	else
		EventStatus("CancelEvent failed");
}


void TimerDlg::OnClickedInevent()
{
	if(globalTimer.InEvent())
		 EventStatus("InEvent=TRUE");
	else EventStatus("InEvent=FALSE");
}


LRESULT TimerDlg::OnPeriodicMessage(WPARAM wParam, LPARAM lParam)
{
char    buff[64];

	m_iMany++;                              // We received another message
	m_iMany+= wParam;               // Add in the messages we may have missed

	if(!(m_iMany % m_iGranularity)) // See if it's time to update our status
	{
		wsprintf(buff, "%u Periodic messages", m_iMany);
		EventStatus(buff);
	}

return 0L;
}

LRESULT TimerDlg::OnOneShotMessage(WPARAM, LPARAM)
{
	EventStatus("Received 1-Shot message");
return 0L;
}


//---------------- Timer Section -----------------

void TimerDlg::OnClickedTimerstart()
{
	TimerStatus("Timer Start");
	GetDlgItem(IDC_TIMERSTOP)->EnableWindow();              // Enable the STOP button
	GetDlgItem(IDC_TIMERCONT)->EnableWindow();              // Enable the CONTINUE button
	globalTimer.Start();                                                    // Start the timer
}

void TimerDlg::OnClickedTimerstop()
{
	TimerStatus("Timer Stop");
	GetDlgItem(IDC_TIMERSTOP)->EnableWindow(FALSE); // Disable the STOP button
	globalTimer.Stop();
}

void TimerDlg::OnClickedTimerread()
{
char    buff[32];

	TimerStatus("Timer Read...");
	wsprintf(buff, "%ld mSecs Elapsed", globalTimer.Read());
	TimerStatus(buff);
}

void TimerDlg::OnClickedTimercont()
{
	TimerStatus("Timer Continue");
	GetDlgItem(IDC_TIMERSTOP)->EnableWindow();              // Enable the STOP button
	globalTimer.Continue();
}

void TimerDlg::OnClickedTimerreset()
{
	TimerStatus("Timer Reset");
	GetDlgItem(IDC_TIMERSTOP)->EnableWindow(FALSE);         // Disable the STOP button
	GetDlgItem(IDC_TIMERCONT)->EnableWindow(FALSE);         // Disable the CONTINUE button
	globalTimer.Reset();
}

void TimerDlg::OnClickedTimerrunning()
{
	if(globalTimer.IsRunning())
		 TimerStatus("Running=TRUE");
	else TimerStatus("Running=FALSE");
}

//------------------- Used by both ----------------------

UINT TimerDlg::GetDelay()
{
BOOL    status;
UINT    delay;

	delay=GetDlgItemInt(IDC_EVENTRATE, &status, FALSE);

	if(!(delay && status))
	{
		EventStatus("Invalid delay time.");
		return 0;
	}
	
return delay;
}

//----------- Routines to handle status displays ---------------
void TimerDlg::OnClickedEventlistclear()
{
	((CListBox *)GetDlgItem(IDC_EVENTLIST))->ResetContent();
}

void TimerDlg::OnClickedTimerlistclear()
{
	((CListBox *)GetDlgItem(IDC_TIMERLIST))->ResetContent();
}

void TimerDlg::TimerStatus(const char* string)
{
	CListBox        *pLB;
	
	pLB=(CListBox *) GetDlgItem(IDC_TIMERLIST);
	pLB->SetCurSel(pLB->AddString(string));
}

void TimerDlg::EventStatus(const char* string)
{
	CListBox        *pLB;
	
	pLB=(CListBox *) GetDlgItem(IDC_EVENTLIST);
	pLB->SetCurSel(pLB->AddString(string));
}




