/* LISTING 5 */
#include <windows.h>
#include <vbapi.h>
#include <string.h>
#include "ipxspx.h"


/************************************************************************/
/*                                                                      */
/*  AllocateECB                 This function is called to allocate     */
/*                              and ECB with an IPX data portion        */
/*                              and do the required trickery for        */
/*                              Windows to not jam up!                  */
/*                                                                      */
/*      Author:    Pierre Goyette                                       */
/*      Company:   McGill University Computing Center                   */
/*      Date:      Jan 6, 1992                                          */
/*      Compiler:  Microsoft C 6.00a                                    */
/*                                                                      */
/*      This function returns a pointer to an ECB or NULL if some       */
/*      problem occurred in allocating or locking the memory.           */
/*                                                                      */
/*      The data (or SPX header and data portion) are allocated         */
/*      in the same block as the ECB and immediately follow the         */
/*      ECB. The address of the SPX header can be calculated using      */
/*      the following code:                                             */
/*                                                                      */
/*           ((VOID FAR *)((LPBYTE)ecbptr + sizeof(ECB)))               */
/*                                                                      */
/*      The strange things that are done is this function are           */
/*      the recommendations of Microsoft themselves.                    */
/*                                                                      */
/*      There are two levels of memory management inside Windows.       */
/*      The first is at the application level. An application MUST      */
/*      perform a GlobalPageLock to prevent the higher memory           */
/*      manager from moving any data into that physical page of         */
/*      memory. Then, the VIPX driver will perform a physical page      */
/*      lock to prevent the page from being moved around in linear      */
/*      memory. The combination of these two locks are required for     */
/*      any application that wants to access IPX/SPX services.          */
/*                                                                      */
/*      The main reason why all of the work is required is that         */
/*      VIPX uses 32-bit linear addresses in its code. Unlike a         */
/*      selector:offset combination, the VIPX driver is not aware       */
/*      if Windows moves the physical page around (in which case        */
/*      only the 386 pagin registers change and not the selector).      */
/*      Therefore, once VIPX converts the selector:offset to a          */
/*      32-bit linear address, the page and data MUST NEVER change      */
/*      until the command is terminated and returned to the application */
/*      program.                                                        */
/*                                                                      */
/*      If the application does not perform a GlobalPageLock, then      */
/*      Windows may hang when the application is terminated or you      */
/*      may be returned directly to DOS after terminating your          */
/*      IPX/SPX application.                                            */
/*                                                                      */
/*      The vnetbios driver does not have this problem because          */
/*      Microsoft completely recoded the driver to use                  */
/*      selector:offset address in the driver instead of 32-bit         */
/*      linear addresses.                                               */
/*                                                                      */
/*      I would like to thank some people at Novell who prefer to       */
/*      rename nameless at this time for their efforts in               */
/*      producing reliable code for IPX applications under Windows.     */
/*                                                                      */
/*      This code is provided on an as-is basis by the author.          */
/*      The author and McGill University do not assume any              */
/*      responsibility for any problems arising from this code.         */
/*                                                                      */
/*      If anyone discovers a problem with this code or a better way    */
/*      to do this, please let me know through the various ways         */
/*      listed below:                                                   */
/*                                                                      */
/*      Compuserv:  72701,2732                                          */
/*      Internet:   Pierre@VM1.McGill.Ca                                */
/*      Tel:        (514) 398-7354                                      */
/*      Fax:        (514) 398-6876                                      */
/*                                                                      */
/************************************************************************/

LPVOID PASCAL AllocateECB( UINT datasize )

        {
        WORD   rc;
        HANDLE memblk;
        LPSTR  blkptr;

        /****************************************************************/
        /* First, allocate FIXED memory, NOT MOVEABLE!!!                */
        /****************************************************************/

        memblk = GlobalAlloc( GMEM_FIXED, datasize );

        if (memblk == NULL)
           {
           return(NULL);
           }


        /****************************************************************/
        /* Next, lock the block in memory to get the address            */
        /* here we use the GlobalWire function because it will relocate */
        /* the block of memory to the lowest possible address in the    */
        /* Global Heap in order to help prevent fragmentation. This     */
        /* is neccessary for the SPXListenForSequencedPacket function   */
        /* which remains active for long periods of time.               */
        /****************************************************************/

        blkptr = GlobalWire( memblk );

        if (blkptr == NULL)
           {
           return(NULL);
           }

        /****************************************************************/
        /* Last, but most important. You MUST PageLock the block to     */
        /* prevent Windows memory manager from moving around the block. */
        /* This is because the IPX support code changes the address to  */
        /* a linear 32 bit address and does not know when memory is     */
        /* relocated by the Windows memory manager.                     */
        /****************************************************************/

        rc = GlobalPageLock( HIWORD( (DWORD)blkptr ) );

        if (rc == 0)
           {
           GlobalUnlock( memblk );
           GlobalFree( memblk );
           return(NULL);
           }

        return( blkptr );
        }

/************************************************************************/
/*                                                                      */
/*  DeallocateECB               This function is called to free         */
/*                              an ECB with an IPX data portion.        */
/*                              This is the counterpart to the          */
/*                              AllocateECB function.                   */
/*                                                                      */
/*      This function will free the Global memory block pointed to      */
/*      by the addressed passed. It can retrieve the memory handle      */
/*      from the address using certain Windows functions and techniques */
/*                                                                      */
/************************************************************************/

VOID PASCAL DeallocateECB( LPVOID blkptr )

        {
        DWORD val;
        WORD  rc;

        /****************************************************************/
        /* The first step is to unlock the page in linear memory.       */
        /* The function requires the selector which is really the       */
        /* high order word of the far pointer.                          */
        /*                                                              */
        /*   WARNING! WARNING! WARNING! WARNING! WARNING! WARNING!      */
        /*                                                              */
        /*  The GlobalPageUnlock function under Windows 3.0a returns    */
        /*  a value of 1.  BUT, GlobalPageUnlock function under         */
        /*  Windows 3.1 returns a value of 0. So, if you want to check  */
        /*  the return code, then you will have to know which version   */
        /*  of Windows you are running on.                              */
        /*                                                              */
        /****************************************************************/

        rc = GlobalPageUnlock( HIWORD( (DWORD)blkptr ) );


        /****************************************************************/
        /* Next, we need the handle of the far pointer in order to      */
        /* Unlock it and free it. The GlobalHandle function will        */
        /* retreive the handle using the selector. Again, we know       */
        /* that the upper word of a far pointer on 286 & 386 systems    */
        /* is really the selector value.                                */
        /****************************************************************/

        val = GlobalHandle( HIWORD( (DWORD)blkptr ) );

        if (val == NULL)
           {
           return;
           }

        if (GlobalUnWire( (HANDLE) LOWORD( val ) ) == FALSE)
           {
           return;
           }

        if (GlobalFree( (HANDLE) LOWORD( val ) ) != NULL)
           {
           return;
           }

        return;
}

