/* LISTING 3 */
#include <windows.h>
#include <vbapi.h>
#include <string.h>
#include "ipxspx.h"

/*----------------------------------------------------------------------
// IPXInstalled returns 1 if IPX is installed
//  		    returns 0 if not
//----------------------------------------------------------------------
*/                                                                      
#pragma warning (disable: 4704)
WORD IPXInstalled(void)
{
	_asm mov ax, 7a00h
	_asm int 2fh
	_asm cmp al,-1
	_asm jz yes
	return 0;
yes:
	return 1;
} 	

/*----------------------------------------------------------------------
// IntSwap will swap the inWord and return it
//----------------------------------------------------------------------
*/	
WORD IntSwap(WORD inWord)
{
	BYTE FAR*bp, FAR*op;
	WORD out;
	
	bp = (BYTE FAR *) &inWord;
	op = (BYTE FAR *) &out;
	
	*(op + 1) = *bp;
	*op = *(bp + 1);
	
	return out;
}

/*-----------------------------------------------------------------------
// SetHlstrFromEcb puts the contents from ecbPtr into the hlstr
//-----------------------------------------------------------------------
*/
WORD SetHlstrFromEcb(HLSTR hLstr,ECB FAR *ecbPtr)
{
	LPSTR lpString;
	WORD len;
	                                                     
	/* find total length of packet, then subtract off the header */	
	len = IntSwap(((IPXHeader FAR *)(ecbPtr->fragmentDescriptor[0].address))->length);
	//len -= sizeof(IPXHeader);
	
	VBResizeHlstr(hLstr,len);
	lpString = VBDerefHlstr(hLstr);
    
    _fmemcpy(lpString,ecbPtr->fragmentDescriptor[0].address,sizeof(IPXHeader));
	_fmemcpy(lpString+sizeof(IPXHeader),ecbPtr->fragmentDescriptor[1].address,len-sizeof(IPXHeader));	
	
	return (VBSetHlstr(&hLstr,lpString, len));	
}


/*-----------------------------------------------------------------------
// SetUpCancel cancels all ecbs on the associated socket
//-----------------------------------------------------------------------
*/
WORD SetUpCancel(HCTL hctl, ECB FAR * ecbPtr, WORD socket)
{
	WORD i, ccode = 0;
	LPIPXSPX lpIPXSPX = (LPIPXSPX)VBDerefControl(hctl);
	WORD numECBs = lpIPXSPX->inECBs + lpIPXSPX->outECBs;
	
	for( i=0; i < numECBs; i++)
	{
		if (ecbPtr->inUseFlag && ecbPtr->socketNumber == socket)
			ccode |= IPXCancelEvent(lpIPXSPX->TaskID,ecbPtr++);
	}
	return (ccode);
}		
		
	
void SetUpListen(HCTL hctl, IPXHeader FAR * ipxHeadPtr, ECB FAR * ecbPtr, char FAR * bufPtr)
{
	WORD i;
	LPIPXSPX lpIPXSPX = (LPIPXSPX)VBDerefControl(hctl);
	WORD numECBs = lpIPXSPX->inECBs;
                                               
	for(i=0; i < numECBs; i++)
	{
		/* Zero out the ecb and the header */
		_fmemset(ecbPtr,0,sizeof(struct ECB));
		_fmemset(ipxHeadPtr,0,sizeof(struct IPXHeader));		
		
		/* Set the socket, remember to swap it */
		ecbPtr->socketNumber = IntSwap(lpIPXSPX->InSocket);
		
		ecbPtr->ESRAddress = ListenESRHandler;
		
		/* Set two fragments, first is for the header,
		   second is for the buffer to be filled with data */
		ecbPtr->fragmentCount = 2;
		ecbPtr->fragmentDescriptor[0].address = ipxHeadPtr;
		ecbPtr->fragmentDescriptor[0].size = sizeof(IPXHeader);
		ecbPtr->fragmentDescriptor[1].address = bufPtr;
		ecbPtr->fragmentDescriptor[1].size = MAX_PACKET_SIZE;
		
		/* Give it to IPX to receive any packets */
		IPXListenForPacket(lpIPXSPX->TaskID, ecbPtr);
		ipxHeadPtr++;
		ecbPtr++;
		bufPtr += MAX_PACKET_SIZE;
	}   
}     
                              
void SetUpSend(HCTL hctl, IPXHeader FAR * ipxHeadPtr, ECB FAR * ecbPtr, char FAR * packet, WORD length)
{
	static BYTE BroadCast[] = {0xff,0xff,0xff,0xff,0xff,0xff};
	LPIPXSPX lpIPXSPX = (LPIPXSPX)VBDerefControl(hctl);
	LPSTR lpAddress = VBDerefHlstr(lpIPXSPX->Address);
	BYTE immediateAddress[6];
 	IPXAddress LocalTarget;
    int	transportTime;             
    WORD numECBs = lpIPXSPX->outECBs;
    
    if (!lpAddress)
    	return;
    
    /* copy the address from our structure into the localtarget and 
       then call IPXGetLocalTarget to fill in the immediate address */	
	_fmemcpy(&LocalTarget,lpAddress,10);
    _fmemcpy(LocalTarget.socket,&lpIPXSPX->OutSocket,2);

	if (!_fmemcmp(LocalTarget.node,BroadCast,6))
		/* broadcast packet */
		_fmemcpy(immediateAddress,BroadCast,6);
	else
		/* get the immediate address with IPXGetLocalTarget */	 	      
 		IPXGetLocalTarget(lpIPXSPX->TaskID,(BYTE FAR *)&LocalTarget,immediateAddress,&transportTime);
 	                                 
	for(;;)
	{ 	                                       
		/* Zero out the ecb and the header */ 	                                         
		_fmemset(ecbPtr,0,sizeof(struct ECB));
		_fmemset(ipxHeadPtr,0,sizeof(struct IPXHeader));
    
	    /* Fill in the destination from our address passed in */
		_fmemcpy(ipxHeadPtr->destination.network,LocalTarget.network,4);
		_fmemcpy(ipxHeadPtr->destination.node,LocalTarget.node,6);	
		_fmemcpy(ipxHeadPtr->destination.socket,&LocalTarget.socket,2);
	
		ipxHeadPtr->packetType = 4;

		/* put the address returned by IPXGetLocalTarget into the immediate address */
		_fmemcpy(ecbPtr->immediateAddress,immediateAddress,6);
	
		ecbPtr->ESRAddress = SendESRHandler;
		ecbPtr->socketNumber = lpIPXSPX->OutSocket;

		/* Set two fragments, first is for the header,
		   second is for the buffer with data */
		ecbPtr->fragmentCount = 2;
		ecbPtr->fragmentDescriptor[0].address = ipxHeadPtr;
		ecbPtr->fragmentDescriptor[0].size = sizeof(struct IPXHeader);
		ecbPtr->fragmentDescriptor[1].address = packet;
		ecbPtr->fragmentDescriptor[1].size = min(length,MAX_PACKET_SIZE);
		
		/* Give it to IPX to receive any packets */
		IPXSendPacket(lpIPXSPX->TaskID, ecbPtr);

		ipxHeadPtr++;
		ecbPtr++;
		packet += MAX_PACKET_SIZE;		                                
		if (length < MAX_PACKET_SIZE)
			break;
		length -= MAX_PACKET_SIZE;
	}
}	

        
#pragma alloc_text(INTERRUPT_TEXT,ListenESR)
        
void ListenESR(ECB FAR * ecbPtr)
{
	static ECB FAR * EcbQueue;
	static ECB FAR * EcbQueueTail = (ECB FAR *)&EcbQueue;
	static WORD ReenterFlag = 0;
                  
	/*/ Check for reentrancy */
	if (ReenterFlag)
	{
		/* Enqueue the ECB */
		EcbQueueTail->linkAddress = (void far *)ecbPtr;
		EcbQueueTail = (ECB far *)ecbPtr;
		ecbPtr->linkAddress = NULL;
		return;
	}

	/* Set the reentrany flag to indicate that we can't allow another thread
	 through the ESR. */
	ReenterFlag++;
                          
	_asm sti                          
	
	/* Process the current ECB */
NextEcb:
	IPXListenForPacket(gIPXTaskID,ecbPtr);
	PostMessage(gIpxSpxHwnd,WM_LISTENESR,(WPARAM)ecbPtr->completionCode,(LPARAM)ecbPtr);

	/* Check for anything on the queue */

	if (EcbQueue)
	{
		ecbPtr = EcbQueue;
		EcbQueue = (ECB FAR *)(EcbQueue->linkAddress);
		if (!EcbQueue)
			EcbQueueTail = (ECB FAR *)&EcbQueue;
		goto NextEcb;
	}
    
    _asm cli
	/* Reset the reentrancy flag to indicate that the first thread is done */
	ReenterFlag--;
	
}


#pragma alloc_text(INTERUPT_TEXT,SendESR)

void SendESR(ECB FAR * ecbPtr)	
{                                                                            
	/* Just send the message upstairs */       
	PostMessage(gIpxSpxHwnd,WM_SENDESR,(WPARAM)ecbPtr->completionCode,(LPARAM)ecbPtr);
}

