/* LISTING 4 */
/*---------------------------------------------------------------------------
// IPXSPX.c
//---------------------------------------------------------------------------
// Contains control procedure for IPXSPX control
//---------------------------------------------------------------------------
*/
#include <windows.h>
#include <vbapi.h>
#include <string.h>   
#include <malloc.h>
#include "ipxspx.h"

/*---------------------------------------------------------------------------
// Local Prototypes
//----------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
// Global Variables
//---------------------------------------------------------------------------
*/
HANDLE hmodDLL;
WORD   cVbxUsers = 0;
LPVOID gAllocatedPtr;
HWND gIpxSpxHwnd;                         
DWORD gIPXTaskID;
                                     

/*---------------------------------------------------------------------------
// IPXSPX Control Procedure
//---------------------------------------------------------------------------
*/
LONG FAR PASCAL _export IPXSPXCtlProc
(
    HCTL   hctl,
    HWND   hwnd,
    USHORT msg,
    USHORT wp,
    LONG   lp
)
{
	LONG lRet = 0;
	BOOL fCallVB = FALSE;
	WORD ccode;
	static IPXHeader FAR * gIpxPtr;
	static ECB FAR * gEcbPtr;
	static LPVOID gBufPtr;
		
    switch (msg)
	{
	case WM_LISTENESR:
		{
		/* message received from the ListenESR
		   fire Receive Event
		*/
	    LPIPXSPX lpIPXSPX = (LPIPXSPX)VBDerefControl(hctl); 
	    
	    lpIPXSPX->Code = wp;               

		SetHlstrFromEcb(lpIPXSPX->Input,(ECB FAR *)lp);		
    	ccode = VBFireEvent(hctl, IEVENT_IPXSPX_LISTEN, NULL);
		break;
		}
		
	case WM_SENDESR:
		{                   
		/* message received from the SendESR
		   fire Send Event
		*/
		LPIPXSPX lpIPXSPX = (LPIPXSPX)VBDerefControl(hctl); 

	    lpIPXSPX->Code = wp;		
                                                        
		SetHlstrFromEcb(lpIPXSPX->Input,(ECB FAR *)lp);		                                                        
    	ccode = VBFireEvent(hctl, IEVENT_IPXSPX_SEND, NULL);
		break;
		}
		
	case WM_NCCREATE:
	    {
	    /* creation of the control, but only do the net
	       stuff if we are running
	    */
	    LPIPXSPX lpIPXSPX = (LPIPXSPX)VBDerefControl(hctl);
		        
        lpIPXSPX->inECBs = DEFAULT_INECBS;
        lpIPXSPX->outECBs = DEFAULT_OUTECBS;

        if (MODE_RUN == VBGetMode())
        {   
        	WORD maxECBs, maxPacketSize, numECBs;
         	maxECBs = DEFAULT_INECBS + DEFAULT_OUTECBS;
        	maxPacketSize = MAX_PACKET_SIZE;

			gIpxSpxHwnd = hwnd;
        	
			ccode = IPXInitialize(&(lpIPXSPX->TaskID), maxECBs, maxPacketSize);

    		if (ccode) 
    			return 0l;                 

			gIPXTaskID = lpIPXSPX->TaskID;    					                                                     
    		
			lpIPXSPX->Input = VBCreateHlstr(NULL,sizeof(IPXHeader));
        	lpIPXSPX->Output = VBCreateHlstr(NULL,0);  
        	lpIPXSPX->Address = VBCreateHlstr(NULL,sizeof(IPXAddress));
        	numECBs = lpIPXSPX->inECBs + lpIPXSPX->outECBs;
        	
        	/* allocate all of the memory for the ECBs, makes for messier
        	   code, but keeps the selector usage to a minimum
        	*/
        	gAllocatedPtr = AllocateECB(numECBs * (sizeof(struct IPXHeader) + sizeof(struct ECB) + MAX_PACKET_SIZE));
        	gIpxPtr = (struct IPXHeader FAR *)gAllocatedPtr;                                                 
    		gEcbPtr = (struct ECB FAR *)(gIpxPtr + numECBs);
			gBufPtr = (LPVOID)(gEcbPtr + numECBs);
		}
    	
    	lRet = 1l;
	    break;
	    }
                                                 
		case WM_NCDESTROY:                   
		{   
			/* destruction of the control, if running,
			   cancel the ECBs and close the sockets
			*/
			LPIPXSPX lpIPXSPX = (LPIPXSPX)VBDerefControl(hctl);
			if (MODE_BREAK == VBGetMode() || MODE_RUN == VBGetMode())
        	{   
				VBDestroyHlstr(lpIPXSPX->Input);
				lpIPXSPX = (LPIPXSPX)VBDerefControl(hctl);                
			
				VBDestroyHlstr(lpIPXSPX->Output);                                                
				lpIPXSPX = (LPIPXSPX)VBDerefControl(hctl);
				if (VBDerefHlstr(lpIPXSPX->Address))
					VBDestroyHlstr(lpIPXSPX->Address);
        
    	    	SetUpCancel(hctl,gEcbPtr, lpIPXSPX->InSocket);
				IPXCloseSocket(lpIPXSPX->TaskID,lpIPXSPX->InSocket);
			
				if (lpIPXSPX->OutSocket != lpIPXSPX->InSocket)          
				{
					SetUpCancel(hctl,gEcbPtr, lpIPXSPX->OutSocket);			
    				IPXCloseSocket(lpIPXSPX->TaskID, lpIPXSPX->OutSocket);
    			}
			
				IPXSPXDeinit(lpIPXSPX->TaskID);
				DeallocateECB(gAllocatedPtr);
			}
			lRet = 0l;
        	break;
        }
              
          
        case VBM_SETPROPERTY:
        {
			LPIPXSPX lpIPXSPX = (LPIPXSPX)VBDerefControl(hctl);			                                
			WORD numECBs, ccode, oldSocket;
								        
	    	switch (wp)
			{               
				case IPROP_IPXSPX_INSOCKET:
					oldSocket = lpIPXSPX->InSocket;
					lpIPXSPX->InSocket = (UINT)lp;
					
					if (MODE_RUN == VBGetMode())
					{                           
						if (oldSocket != (UINT)lp)
						{
							/* terminate the old socket and its ecbs, if any */
				        	SetUpCancel(hctl,gEcbPtr, oldSocket);
							IPXCloseSocket(lpIPXSPX->TaskID,oldSocket);

				    		ccode = IPXOpenSocket(lpIPXSPX->TaskID, &lpIPXSPX->InSocket, LONG_LIVED);
			    			if (ccode)
    							return (LONG)ccode;
							SetUpListen(hctl, gIpxPtr, gEcbPtr, gBufPtr);
    					}							
					}					
					return 0l;
					
				case IPROP_IPXSPX_OUTSOCKET:       
					oldSocket = lpIPXSPX->OutSocket;				
					lpIPXSPX->OutSocket = (UINT)lp;
					
					if (MODE_RUN == VBGetMode())
					{
			    		if (oldSocket != (UINT)lp && lpIPXSPX->OutSocket != lpIPXSPX->InSocket)
    					{
							/* terminate the old socket and its ecbs, if any */
				        	SetUpCancel(hctl,gEcbPtr, oldSocket);
							IPXCloseSocket(lpIPXSPX->TaskID,oldSocket);
    					
    						ccode = IPXOpenSocket(lpIPXSPX->TaskID, &lpIPXSPX->OutSocket, LONG_LIVED);
    						if (ccode)
    							return (LONG)ccode;
    					}
    				}
					return 0l;
					
				case IPROP_IPXSPX_OUTPUT:
					if (VBDerefHlstr((HLSTR)lp) != NULL)
					{
						if (MODE_RUN == VBGetMode())                                  
						{                                
							LPSTR lpOutput;                          
							WORD len;
		
							VBSetHlstr(&lpIPXSPX->Output,(HLSTR)lp, (WORD)-1);	
						
							numECBs  = lpIPXSPX->inECBs;
							lpOutput = VBDerefHlstr(lpIPXSPX->Output);
							len = VBGetHlstrLen(lpIPXSPX->Output);
							len = min(len,MAX_PACKET_SIZE);
							VBResizeHlstr(lpIPXSPX->Output,len);
							lpOutput = _fmemcpy((char FAR *)gBufPtr+(numECBs * MAX_PACKET_SIZE), lpOutput, len);
							SetUpSend(hctl, gIpxPtr + numECBs, gEcbPtr + numECBs, lpOutput, len);
						}
					}
					return 0l;				
				}
			
		}				
		
		default:
			fCallVB = TRUE;
	}
                           
    if (fCallVB)
    	lRet =  VBDefControlProc(hctl, hwnd, msg, wp, lp);
    	
    return (lRet);
}


/*---------------------------------------------------------------------------
// Register custom control. This routine is called by VB when the custom
// control DLL is loaded for use.
//---------------------------------------------------------------------------
*/
BOOL FAR PASCAL _export VBINITCC
(
    USHORT usVersion,
    BOOL   fRuntime
)
{
	if (!IPXInstalled())
	{
		VBSetErrorMessage(20000,"IPX not installed");
		VBRuntimeError(20000);
		return (FALSE);
	}
    /* Count the number of hosts using this VBX.  A host can be vb.exe,
    // any .exe compiled from vb which uses this custom control, or any
    // other program which loads and uses VBX files.
    */
    ++cVbxUsers;
    
    if (cVbxUsers > 1)
    {
    	/* can't do more than one because of socket and globals problems */
    	--cVbxUsers;          
		VBSetErrorMessage(20001,"Currently only 1 user allowed");
		VBRuntimeError(20001);    	
    	return (FALSE);
    }

	return VBRegisterModel(hmodDLL, &modelIPXSPX);
}


/*---------------------------------------------------------------------------
// Unregister custom control.  This routine is called by VB when the custom
// control DLL is being unloaded.
//---------------------------------------------------------------------------
*/
VOID FAR PASCAL _export VBTERMCC
(
    VOID
)
{
    --cVbxUsers;
    return;
}


/*---------------------------------------------------------------------------
// Provide custom control model information to host environment.
//---------------------------------------------------------------------------
*/
LPMODELINFO FAR PASCAL _export VBGetModelInfo
(
    USHORT usVersion
)
{
		return &modelinfoIPXSPX;
}


/*---------------------------------------------------------------------------
// Initialize library.	This routine is called when the first client loads
// the DLL.
//---------------------------------------------------------------------------
*/
int FAR PASCAL LibMain
(
    HANDLE hModule,
    WORD   wDataSeg,
    WORD   cbHeapSize,
    LPSTR  lpszCmdLine
)
{
    /*/ Avoid warnings on unused (but required) formal parameters */
    wDataSeg	= wDataSeg;
    cbHeapSize	= cbHeapSize;
    lpszCmdLine = lpszCmdLine;

    hmodDLL = hModule;

    return 1;
}


/*---------------------------------------------------------------------------
// WEP
//---------------------------------------------------------------------------
// C7 and QCWIN provide default a WEP:
//---------------------------------------------------------------------------
*/
#if (_MSC_VER < 610)

int FAR PASCAL WEP(int fSystemExit);

/*---------------------------------------------------------------------------
// For Windows 3.0 it is recommended that the WEP function reside in a
// FIXED code segment and be exported as RESIDENTNAME.  This is
// accomplished using the alloc_text pragma below and the related EXPORTS
// and SEGMENTS directives in the .DEF file.
//
// Read the comments section documenting the WEP function in the Windows
// 3.1 SDK "Programmers Reference, Volume 2: Functions" before placing
// any additional code in the WEP routine for a Windows 3.0 DLL.
//---------------------------------------------------------------------------
*/
#pragma alloc_text(WEP_TEXT,WEP)

/*---------------------------------------------------------------------------
// Performs cleanup tasks when the DLL is unloaded.  WEP() is
// called automatically by Windows when the DLL is unloaded (no
// remaining tasks still have the DLL loaded).	It is strongly
// recommended that a DLL have a WEP() function, even if it does
// nothing but returns success (1), as in this example.
//---------------------------------------------------------------------------
*/
int FAR PASCAL WEP
(
    int fSystemExit
)
{
    /* Avoid warnings on unused (but required) formal parameters */
    fSystemExit = fSystemExit;

    return 1;
}
#endif /*/ C6 */

/*/---------------------------------------------------------------------------*/
