/* LISTING 1 */
#ifndef __ipxspx_h
#define __ipxspx_h
/*--------------------------------------------------------------------------
// IPXSPX.h
//---------------------------------------------------------------------------
*/

/*--------------------------------------------------------------------------
// Resource Information
//---------------------------------------------------------------------------
*/

/* Toolbox bitmap resource IDs numbers.
//---------------------------------------------------------------------------
*/
#define IDBMP_IPXSPX		8000
#define IDBMP_IPXSPXDOWN	8001
#define IDBMP_IPXSPXMONO	8003
#define IDBMP_IPXSPXEGA 	8006

/*---------------------------------------------------------------------------
// Change these for each new VBX file
//---------------------------------------------------------------------------
*/
#define VBX_COMPANYNAME 	   "NoName\0"
#define VBX_FILEDESCRIPTION	   "Visual Basic IPXSPX Custom Control Example\0"
#define VBX_INTERNALNAME	   "IPXSPX\0"
#define VBX_LEGALCOPYRIGHT	   "\0"
#define VBX_LEGALTRADEMARKS	   "\0"
#define VBX_ORIGINALFILENAME	"IPXSPX.VBX\0"
#define VBX_PRODUCTNAME 	   "\0"

/*---------------------------------------------------------------------------
// Update these fields for each build.
//---------------------------------------------------------------------------
*/
#define VBX_VERSION		    1,00,0,00
#define VBX_VERSION_STR 	   "1.00.000\0"

#ifndef RC_INVOKED


/*---------------------------------------------------------------------------
// Macro for referencing member of structure
//---------------------------------------------------------------------------
*/
#define OFFSETIN(struc, field)	    ((USHORT)&(((struc *)0)->field))


/*---------------------------------------------------------------------------
// Control and Window Procedures
//---------------------------------------------------------------------------
*/
LONG FAR PASCAL _export IPXSPXCtlProc(HCTL, HWND, USHORT, USHORT, LONG);

/*---------------------------------------------------------------------------
// Global Variables and Constants
//---------------------------------------------------------------------------
*/
extern	HANDLE hmodDLL;
extern  HWND gIpxSpxHwnd;
extern  DWORD gIPXTaskID;
#define SOCKET_NUMBER 0x5454  
#define MAX_BRIDGE_PACKET	576
#define MAX_PACKET_SIZE 	(MAX_BRIDGE_PACKET - sizeof(IPXHeader))
#define DEFAULT_INECBS 			3
#define DEFAULT_OUTECBS			1

/*---------------------------------------------------------------------------
// IPXSPX control data and structs
//---------------------------------------------------------------------------
*/

typedef struct tagIPXSPX
    { 
	  DWORD TaskID;
      WORD InSocket;
      WORD OutSocket;
      WORD inECBs;
      WORD outECBs;
      HLSTR Input;
      HLSTR Output;
      HLSTR Address;
      WORD Code;
    } IPXSPX;

typedef IPXSPX FAR * LPIPXSPX;

#define LpIPXSPXDEREF(hctl)     ((LPIPXSPX)VBDerefControl(hctl))

    typedef struct IPXAddress
        {
        BYTE    network[4];              /* high-low */
        BYTE    node[6];                  /* high-low */
        BYTE    socket[2];              /* high-low */
        }IPXAddress;


    typedef struct IPXHeader
        {
        WORD        checkSum;               /* high-low */
        WORD        length;                 /* high-low */
        BYTE        transportControl;
        BYTE        packetType;
        IPXAddress  destination;
        IPXAddress  source;
        }IPXHeader;

        typedef struct ECBFragment
            {
            void far *address;
            WORD    size;                /* low-high */
            }ECBFragment;

        typedef struct ECB
            {
            void far *linkAddress;
            void (far *ESRAddress)();
            BYTE        inUseFlag;
            BYTE        completionCode;
            WORD        socketNumber;               /* high-low */
            BYTE        IPXWorkspace[4];            /* N/A */
            BYTE        driverWorkspace[12];        /* N/A */
            BYTE        immediateAddress[6];        /* high-low */
            WORD        fragmentCount;              /* low-high */
            ECBFragment fragmentDescriptor[2];
            }ECB;

    /* Completion Codes */

    #ifndef SUCCESSFUL
    #define SUCCESSFUL                      0x00
    #endif

    #define SPX_NOT_INSTALLED               0x00
    #define SPX_INSTALLED                   0xFF    
    #define SPX_CONNECTION_OK               0x00
    #define SPX_CONNECTION_STARTED          0x00
    #define SPX_CONNECTION_ESTABLISHED      0x00
    #define SPX_PACKET_SUCCESSFUL           0x00
    #define SPX_SOCKET_NOT_OPENED           0xFF
    #define SPX_MALFORMED_PACKET            0xFD
    #define SPX_PACKET_OVERFLOW             0xFD
    #define SPX_LISTEN_CANCELED             0xFC
    #define SPX_CONNECTION_TABLE_FULL       0xEF
    #define SPX_INVALID_CONNECTION          0xEE
    #define SPX_NO_ANSWER_FROM_TARGET       0xED
    #define SPX_CONNECTION_FAILED           0xED
    #define SPX_CONNECTION_TERMINATED       0xED
    #define SPX_TERMINATED_POORLY           0xEC

    #define NO_MGMT_MEMORY                  0xF0
    #define IPXSPX_NOT_INIT                 0xF1
    #define IPX_NOT_INIT                    0xF1
    #define NO_DOS_MEMORY                   0xF2
    #define NO_FREE_ECB                     0xF3
    #define WINLOCK_FAILED                  0xF4
    #define OVER_MAX_LIMIT                  0xF5
    #define IPXSPX_PREV_INIT                0xF6

    #define CANCEL_FAILURE                  0xF9
    #define NO_PATH_TO_DESTINATION_FOUND    0xFA
    #define ECB_CANCELLED                   0xFC
    #define PACKET_OVERFLOW                 0xFD
    #define PACKET_UNDELIVERABLE            0xFE
    #define SOCKET_NOT_OPEN                 0xFF
    #define TRANSMIT_FAILURE                0xFF
    #define ECB_NOT_IN_USE                  0xFF
    #define SOCKET_ALREADY_OPEN             0xFF
    #define IMMEDIATE_ADDRESS_COMPLETE      0x7777

	#define SHORT_LIVED 					0x00
	#define LONG_LIVED						0xff
	

#ifdef __cplusplus
   extern "C" {
#endif /* __cplusplus */

WORD IPXInstalled(void);
WORD IntSwap(WORD inWord);
LPVOID PASCAL AllocateECB( UINT datasize );
VOID PASCAL DeallocateECB( LPVOID blkptr );
void SetUpListen(HCTL hctl, IPXHeader FAR * ipxHeadPtr, ECB FAR * ecbPtr, char FAR * bufPtr);
void SetUpSend(HCTL hctl, IPXHeader FAR * ipxHeadPtr, ECB FAR * ecbPtr, char FAR * bufPtr, WORD length);
WORD SetUpCancel(HCTL hctl, ECB FAR * ecbPtr, WORD socket);
WORD SetHlstrFromEcb(HLSTR hLstr, ECB FAR * ecbPtr);
void far ListenESRHandler(void);
void far SendESRHandler(void);
void far ListenESR(ECB FAR * ecbPtr);
void far SendESR(ECB FAR * ecbPtr);

/* IPX/SPX(tm) prototypes */
extern int FAR PASCAL  IPXCancelEvent(
                                       DWORD IPXTaskID, 
                                       ECB FAR *eventControlBlock);

extern void FAR PASCAL IPXCloseSocket(
                                       DWORD IPXTaskID,
                                       WORD socket);

extern void FAR PASCAL IPXDisconnectFromTarget(
                                       DWORD IPXTaskID, 
                                       BYTE FAR *internetAddress);

extern void FAR PASCAL IPXGetInternetworkAddress(
                                       DWORD IPXTaskID, 
                                       BYTE FAR *internetAddress);

extern WORD FAR PASCAL IPXGetIntervalMarker(
                                     DWORD IPXTaskID );

extern int  FAR PASCAL IPXGetLocalTarget(
                                       DWORD IPXTaskID, 
                                       BYTE FAR *destination, 
                                       BYTE FAR *immediateAddress, 
                                       int FAR *transportTime);

extern WORD FAR PASCAL IPXGetMaxPacketSize(void);

extern WORD FAR PASCAL IPXGetRetryCount(void);

extern int  FAR PASCAL IPXInitialize(
                                       DWORD FAR *IPXTaskID, 
                                       WORD maxECBs, 
                                       WORD maxPacketSize);

extern int  FAR PASCAL IPXSPXDeinit(DWORD IPXTaskID);

extern void FAR PASCAL IPXListenForPacket(
                                       DWORD IPXTaskID, 
                                       ECB FAR *eventControlBlock);

extern int  FAR PASCAL IPXOpenSocket(
                                       DWORD IPXTaskID,
                                       WORD FAR *socket, 
                                       BYTE socketType);

extern void FAR PASCAL IPXRelinquishControl(void);

extern void FAR PASCAL IPXScheduleIPXEvent(
                                       DWORD IPXTaskID, 
                                       WORD timeDelay, 
                                       ECB FAR *eventControlBlock);

extern void FAR PASCAL IPXSendPacket(
                                       DWORD IPXTaskID, 
                                       ECB FAR *eventControlBlock);

extern void FAR PASCAL IPXYield(void);
                 
                                            
#ifdef __cplusplus
   }
#endif /* __cplusplus */
                                       

/*---------------------------------------------------------------------------
// Private messages
//---------------------------------------------------------------------------
*/
#define WM_LISTENESR WM_USER
#define WM_SENDESR	WM_LISTENESR + 1

/*---------------------------------------------------------------------------
// Property info
//---------------------------------------------------------------------------
*/

/*---------------------------------------------------------------------------
// Property list
//---------------------------------------------------------------------------
// Define the consecutive indicies for the properties
//---------------------------------------------------------------------------
*/

#define IPROP_IPXSPX_CTLNAME		  	  0
#define IPROP_IPXSPX_INDEX                1
#define IPROP_IPXSPX_LEFT                 2
#define IPROP_IPXSPX_TOP                  3
#define IPROP_IPXSPX_TAG                  4
#define IPROP_IPXSPX_INSOCKET			  5
#define IPROP_IPXSPX_OUTSOCKET            6
#define IPROP_IPXSPX_INECBS			  	  7
#define IPROP_IPXSPX_OUTECBS			  8
#define IPROP_IPXSPX_ENABLED		 	  9
#define IPROP_IPXSPX_HWND            	  10
#define IPROP_IPXSPX_INPUT				  11
#define IPROP_IPXSPX_OUTPUT				  12
#define IPROP_IPXSPX_ADDRESS			  13
#define IPROP_IPXSPX_COMPLETION_CODE	  14

extern MODEL modelIPXSPX;
extern MODELINFO modelinfoIPXSPX;

/*---------------------------------------------------------------------------
// Event list
//---------------------------------------------------------------------------
*/

/* Define the consecutive indicies for the events
//---------------------------------------------------------------------------
*/
#define IEVENT_IPXSPX_LISTEN			  0
#define IEVENT_IPXSPX_SEND				  1


#endif	/* RC_INVOKED */
#endif  // #ifndef
//---------------------------------------------------------------------------

