/*--------------------------------------------------
      SECTIONS.C

      A library that counts the number of threads
      and processes that attach themselves to it.  
      The library's exported functions return the
      current tally values.
  --------------------------------------------------*/

#include <windows.h>
#include <stdio.h>
#include "sections.h"

/*--------------------------------------------------
      GLOBAL VARIABLES

      uNumClients          total number of processes
      uNumThreadsGlobal    total number of threads
      uNumThreadsLocal     total threads from the
                              current process only
  --------------------------------------------------*/

#pragma data_seg( ".Global" )    /* SHARED section */
UINT uNumClients = 0;            
UINT uNumThreadsGlobal = 0;

#pragma data_seg( ".Local" )     /* PRIVATE section */
UINT uNumThreadsLocal = 0;          
#pragma data_seg( )              /* restore default */

/*--------------------------------------------------
      DLL MAIN
      Adjust totals as clients attach and
      detach themselves.
  --------------------------------------------------*/

BOOL WINAPI DllMain(HINSTANCE hinstDLL,
   DWORD dwReason, LPVOID lpReserved)
{
   switch (dwReason)
   {
      case DLL_PROCESS_ATTACH:
         uNumClients++;
         /* fall through for the primary thread */

      case DLL_THREAD_ATTACH:
         uNumThreadsLocal++;     
         uNumThreadsGlobal++;    
         break;

      case DLL_THREAD_DETACH:    
         uNumThreadsLocal--;     
         uNumThreadsGlobal--;    
         break;

      case DLL_PROCESS_DETACH:   
         uNumClients--;
         break;
   }
   return(TRUE);
}

/*--------------------------------------------------
      GET NUM CLIENTS
  --------------------------------------------------*/

UINT GetNumClients(void)
{
   return(uNumClients);
}

/*--------------------------------------------------
      GET NUM THREADS LOCAL
  --------------------------------------------------*/

UINT GetNumThreadsLocal(void)
{
   return(uNumThreadsLocal);
}

/*--------------------------------------------------
      GET NUM THREADS GLOBAL
  --------------------------------------------------*/

UINT GetNumThreadsGlobal(void)
{
   return(uNumThreadsGlobal);
}
