#include <windows.h>
#include "checklst.h"

LRESULT __export CALLBACK CheckLstWndFn( HWND, UINT,
        WPARAM, LPARAM );
static void DoDrawItem( HWND,    const DRAWITEMSTRUCT FAR * );


BOOL FAR PASCAL RegisterCheckLstClass( HANDLE hInst )
{
    WNDCLASS wc;

    wc.hCursor      = LoadCursor( NULL, IDC_ARROW );
    wc.hIcon        = NULL;
    wc.lpszMenuName = NULL;
    wc.lpszClassName= "checklst";
    wc.hbrBackground= (HBRUSH)( COLOR_WINDOW + 1 );
    wc.hInstance    = hInst;
    wc.style        = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc  = CheckLstWndFn;
    wc.cbClsExtra   = 0;
    wc.cbWndExtra   = sizeof( HWND ) + sizeof( LONG );
    if( !RegisterClass( &wc ) )
        return( FALSE );
    return( TRUE );
}

LRESULT __export CALLBACK CheckLstWndFn(HWND hwnd, 
    UINT message, WPARAM wParam, LPARAM lParam )
{
    HWND hwndList;

    switch( message )
        {
        case LB_ADDSTRING:
        case LB_INSERTSTRING:
        case LB_DELETESTRING:
        case LB_RESETCONTENT:
        case LB_SETSEL:
        case LB_SETCURSEL:
        case LB_GETSEL:
        case LB_GETCURSEL:
        case LB_GETTEXT:
        case LB_GETTEXTLEN:
        case LB_GETCOUNT:
        case LB_SELECTSTRING:
        case LB_DIR:
        case LB_GETTOPINDEX:
        case LB_FINDSTRING:
        case LB_GETSELCOUNT:
        case LB_GETSELITEMS:
        case LB_SETTABSTOPS:
        case LB_GETHORIZONTALEXTENT:
        case LB_SETHORIZONTALEXTENT:
        case LB_SETCOLUMNWIDTH:
        case LB_SETTOPINDEX:
        case LB_GETITEMRECT:
        case LB_GETITEMDATA:
        case LB_SETITEMDATA:
        case LB_SELITEMRANGE:
        case LB_SETCARETINDEX:
        case LB_GETCARETINDEX:
        case WM_ENABLE:
        case WM_ERASEBKGND:
        case WM_SETREDRAW:
        case WM_VSCROLL:
        case WM_HSCROLL:
            hwndList = (HWND)GetWindowWord( hwnd, 0 );
            return( SendMessage( hwndList, message,
                            wParam, lParam ) );

        case WM_NCCREATE: {
            LPCREATESTRUCT lpCreateStruct;
            DWORD dwStyle;

            lpCreateStruct = (LPCREATESTRUCT)lParam;
            dwStyle = lpCreateStruct->style;
            SetWindowLong( hwnd, 2, (LPARAM)dwStyle );
            dwStyle &= ~WS_VSCROLL;
            dwStyle &= ~WS_HSCROLL;
            SetWindowLong( hwnd, GWL_STYLE, (LPARAM)dwStyle );
            break;
            }

        case WM_CREATE: {
            DWORD dwStyle;
            LPCREATESTRUCT lpCreateStruct;

            lpCreateStruct = (LPCREATESTRUCT)lParam;
            dwStyle = GetWindowLong( hwnd, 2 ) | WS_CHILD |
                          LBS_NOTIFY | LBS_OWNERDRAWFIXED |
                          LBS_HASSTRINGS | LBS_MULTIPLESEL;
            hwndList = CreateWindow( "listbox", NULL,
                            dwStyle, 0, 0, 0, 0, hwnd, NULL,
                          lpCreateStruct->hInstance, NULL );
            SetWindowWord( hwnd, 0, (WORD)hwndList );
            break;
            }

        case WM_DRAWITEM: {
            const DRAWITEMSTRUCT FAR * lpDrawItem;

            lpDrawItem = (const DRAWITEMSTRUCT FAR *)lParam;
            DoDrawItem( hwnd, lpDrawItem );
            return( TRUE );
            }

        case WM_MEASUREITEM: {
            MEASUREITEMSTRUCT FAR * lpMeasureItem;
            TEXTMETRIC tm;
            HDC hdc;

            lpMeasureItem = (MEASUREITEMSTRUCT FAR *)lParam;
            hdc = GetDC( hwnd );
            GetTextMetrics( hdc, &tm );
            lpMeasureItem->itemHeight =
                tm.tmHeight + tm.tmExternalLeading;
            ReleaseDC( hwnd, hdc );
            return( TRUE );
            }

        case WM_DELETEITEM:
        case WM_COMPAREITEM:
            return( SendMessage( GetParent( hwnd ),
                    message, wParam, lParam ) );

        case WM_COMMAND:
            return( SendMessage( GetParent( hwnd ), message,
                        GetDlgCtrlID( hwnd ),
                        MAKELPARAM( hwnd, HIWORD( lParam ) ) ) );

        case WM_SETFOCUS:
            hwndList = (HWND)GetWindowWord( hwnd, 0 );
            SetFocus( hwndList );
            break;

        case WM_DESTROY:
            hwndList = (HWND)GetWindowWord( hwnd, 0 );
            DestroyWindow( hwndList );
            break;

        case WM_SIZE: {
            MEASUREITEMSTRUCT ms;
            RECT rc;

            hwndList = (HWND)GetWindowWord( hwnd, 0 );
            SendMessage( hwnd, WM_MEASUREITEM,
                             GetDlgCtrlID( hwnd ),
                             (LPARAM)(LPSTR)&ms );
            GetClientRect( hwnd, &rc );
            if( rc.bottom % ms.itemHeight )
                {
                RECT rcWnd;

                GetWindowRect( hwnd, &rcWnd );
                SetWindowPos( hwnd, NULL, 0, 0,
                        rcWnd.right - rcWnd.left,
                        ( ( rc.bottom / ms.itemHeight ) *
                            ms.itemHeight ) + ( ( rcWnd.bottom -
                            rcWnd.top ) - rc.bottom ),
                        SWP_NOACTIVATE |
                        SWP_NOMOVE | SWP_NOZORDER );
                GetClientRect( hwnd, &rc );
                }
            SetWindowPos( hwndList, NULL, 0, 0,
                rc.right + GetSystemMetrics( SM_CXBORDER ) * 2,
                rc.bottom + GetSystemMetrics( SM_CYBORDER ) *2,
                SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOZORDER );
            break;
            }
        }
    return( DefWindowProc( hwnd, message, wParam, lParam ));
}


static void DoDrawItem( HWND hwnd,
    const DRAWITEMSTRUCT FAR * lpDrawItem )
{
    HBRUSH hbr;
    RECT rc;

    rc = lpDrawItem->rcItem;
    hbr = CreateSolidBrush(    GetSysColor( COLOR_WINDOW ) );
    FillRect( lpDrawItem->hDC, &rc, hbr );
    if( lpDrawItem->itemID != (UINT)-1 ) {
        char sz[ 200 ];
        HWND hwndList;
        COLORREF crText, crBack;
        RECT rcCheck;
        int nDim;

        hwndList = (HWND)GetWindowWord( hwnd, 0 );
        SendMessage( hwndList, LB_GETTEXT, lpDrawItem->itemID,
                        (LONG)(LPSTR)sz );
        rc.left += 2;
        crText = SetTextColor( lpDrawItem->hDC,
            GetSysColor( COLOR_WINDOWTEXT ) );
        crBack = SetBkColor( lpDrawItem->hDC,
            GetSysColor( COLOR_WINDOW ) );
        DrawText( lpDrawItem->hDC, sz, -1,
                     &rc, DT_NOPREFIX|DT_SINGLELINE|DT_VCENTER );
        SetTextColor( lpDrawItem->hDC, crText );
        SetBkColor( lpDrawItem->hDC, crBack );
//???        nDim = rc.bottom - rc.top;
        SetRect( &rcCheck, ( rc.right - 18 ), rc.top + 1,
                                 rc.right - 5, rc.bottom - 1 );
        FrameRect( lpDrawItem->hDC, &rcCheck,
                GetStockObject( BLACK_BRUSH ) );

        if( lpDrawItem->itemState & ODS_SELECTED ) {
            MoveTo( lpDrawItem->hDC, rcCheck.left,
                      rcCheck.top );
            LineTo( lpDrawItem->hDC, rcCheck.right,
                      rcCheck.bottom );
            MoveTo( lpDrawItem->hDC, rcCheck.right - 1,
                      rcCheck.top );
            LineTo( lpDrawItem->hDC, rcCheck.left - 1,
                      rcCheck.bottom );
            }
        else {
            InflateRect( &rcCheck, -1, -1 );
            FillRect( lpDrawItem->hDC, &rcCheck, hbr );
            }
        DeleteObject( hbr );
        }
    if( lpDrawItem->itemState & ODS_FOCUS )
        DrawFocusRect( lpDrawItem->hDC,
                            (LPRECT)&lpDrawItem->rcItem );
}

