/**************************************************

  Test rig for Multiple Selection Listbox

**************************************************/

#include <windows.h>
#include "checklst.h"
#include "testrc.h"

BOOL FAR PASCAL TestRigProc( HWND, UINT,
							WPARAM, LPARAM );

BOOL DoCommand( HWND hwnd, int id );

char * szFruitNames[] = { "Apples", "Bananas", "Oranges",
	"Pears", "Plums", "Peaches", "Cherries", "Lemons",
	"Limes", "Grapes", NULL };
char sz[ 200 ];

/***************************************************/
/* WinMain														*/
/***************************************************/

#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain(
	HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPSTR lpszCmdLine,
	int nCmdShow )
{
	if( !RegisterCheckLstClass( hInstance ) )
		return( FALSE );
	DialogBox( hInstance, "FRUIT", NULL, TestRigProc );
	return( TRUE );
}

/***************************************************/
/* TestRigProc													*/
/***************************************************/

#ifdef __BORLANDC__
    #pragma argsused
#endif
BOOL FAR PASCAL TestRigProc(
	HWND hwnd,
	UINT message,
	WPARAM wParam,
	LPARAM lParam )
{
	switch( message )
		{
		case WM_INITDIALOG:
			return( TRUE );

		case WM_COMMAND:
			return( DoCommand( hwnd, wParam ) );
		}
	return( FALSE );
}

/***************************************************/
/* DoCommand													*/
/***************************************************/

BOOL DoCommand( HWND hwnd, int id )
{
	switch( id ) {
		case IDD_ADD: {
			HWND hwndList;
			register int c;

			hwndList = GetDlgItem( hwnd, IDD_LSTBOX );
			for( c = 0; szFruitNames[ c ]; ++c )
				SendMessage( hwndList, LB_ADDSTRING, 0,
								 (LONG)(LPSTR)szFruitNames[ c ] );
			break;
			}

		case IDOK: {
			HWND hwndList;
			int count;
			int index;

			hwndList = GetDlgItem( hwnd, IDD_LSTBOX );
			count = (int)SendMessage( hwndList, LB_GETCOUNT,
											  0, 0L );
			lstrcpy( sz, "You have chosen" );
			for( index = 0; index < count; ++index )
				if( SendMessage( hwndList, LB_GETSEL,
										index, 0L ) )
					{
					char sz2[ 40 ];

					SendMessage( hwndList, LB_GETTEXT,
									 index, (LONG)(LPSTR)sz2 );
					lstrcat( lstrcat( sz, " " ), sz2 );
					}
			MessageBox( hwnd, sz, "Fruit",
						   MB_OK|MB_ICONINFORMATION );
			}

		case IDCANCEL:
			EndDialog( hwnd, NULL );
			return( TRUE );
		}
	return( FALSE );
}

