/*****************************************************
           File Name: E_R_DEMO.C
       Expanded Name: Edit Range Demo
         Description: Edit Range Custom Control Demo
                      Program
        Program List: E_R_DEMO.C EDITRANG.C SUBCLASS.C
         Portability: MS Windows, Any memory model,
                      Any windows compatable C Compiler
******************************************************/

/* MSC */
#include <malloc.h>

/* MS Windows */
#include <windows.h>

/* Types and Prototypes */
#include "editrang.h"
#include "subclass.h"

/* Own */
#include "e_r_demo.h"

/* Prototypes of functions called only by windows. */
LRESULT CALLBACK EditRangeDemoProc(
      HWND hWnd, UINT wMessage, WPARAM wParam,
      LPARAM lParam );
BOOL CALLBACK EditRangeDialogProc(
      HWND hDlg, UINT wMessage, WPARAM wParam,
      LPARAM lParam );

/* Static function prototypes */
static void SetCheckBox( HWND hDlg, WORD BoxIndex,
      WORD Init );

/*****************************************************
       Name: WinMain
Description: Program entry point.
*****************************************************/
#ifdef __BORLANDC__
    #pragma argsused
#endif
int PASCAL WinMain( HINSTANCE hInstance,
      HINSTANCE hPrevInstance, LPSTR lpszCmdParam,
      int nCmdShow )
   {

   HWND hWnd;
   MSG Message;
   WNDCLASS WndClass;
   char *EditRangeDemoName = "EditRangeDemo";

   if ( !hPrevInstance )
      {

      if ( !RegisterSubClass( "EDITRANGE", "EDIT",
            hInstance, EditRangeProc,
            ER_CLSEXTRA, ER_WNDEXTRA ) )
         {
         MessageBeep( 0 );
         return ( FALSE );
         }

      WndClass.style = CS_HREDRAW | CS_VREDRAW;
      WndClass.lpfnWndProc = EditRangeDemoProc;
      WndClass.cbClsExtra = 0;
      WndClass.cbWndExtra = 0;
      WndClass.hInstance = hInstance;
      WndClass.hIcon = LoadIcon( hInstance,
            EditRangeDemoName );
      WndClass.hCursor =
            LoadCursor( NULL, IDC_ARROW );
      WndClass.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
      WndClass.lpszMenuName =
            EditRangeDemoName;
      WndClass.lpszClassName =
            EditRangeDemoName;
      if ( RegisterClass( &WndClass ) == FALSE )
         {
         MessageBeep( 0 );
         return ( FALSE );
         }
      }   /* if !hPrevInstance */

   /* Create main window with default pos. and size */
   hWnd = CreateWindow( EditRangeDemoName,
         "Edit Range Demo",
         WS_OVERLAPPEDWINDOW | WS_VISIBLE |
         WS_VSCROLL | WS_HSCROLL,
         CW_USEDEFAULT, CW_USEDEFAULT,
         CW_USEDEFAULT, CW_USEDEFAULT,
         NULL, NULL, hInstance, NULL );

   if ( hWnd == NULL )
      {
      /* If window could not be created, return. */
      MessageBeep( 0 );
      return ( FALSE );
      }

   ShowWindow( hWnd, nCmdShow );
   UpdateWindow( hWnd );

   while ( GetMessage( &Message, NULL, NULL, NULL ) )
      {
      TranslateMessage( &Message );
      DispatchMessage( &Message );
      }

   return ( (int)Message.wParam );

   }   /* function WinMain */


/*****************************************************
       Name: EditRangeDemoProc
Description: Window Procedure for center window demo
             program.  This is called by Windows only.
*****************************************************/
LRESULT CALLBACK EditRangeDemoProc( HWND hWnd,
      UINT wMessage, WPARAM wParam, LPARAM lParam )
   {

   if ( wMessage == WM_DESTROY )
      {
      PostQuitMessage( 0 );
      return ( FALSE );
      }
   if ( wMessage != WM_COMMAND )
      /* Process all the other messages */
      return ( DefWindowProc( hWnd, wMessage,
            wParam, lParam ) );
   /* Process the WM_COMMAND message */
   if ( wParam == IDM_EXIT )
      {
      SendMessage( hWnd, WM_CLOSE, 0, 0L );
      return ( FALSE );
      }
   if ( wParam == IDM_DIALOG )
      {
      FARPROC lpfEditRangeDialog;
      HINSTANCE hInstance;
      hInstance = (HINSTANCE)GetWindowWord( hWnd,
            GWW_HINSTANCE );
      lpfEditRangeDialog = MakeProcInstance(
            (FARPROC)EditRangeDialogProc, hInstance );
      DialogBox( hInstance, "EditRangeDemo", hWnd,
            (DLGPROC)lpfEditRangeDialog );
      FreeProcInstance( lpfEditRangeDialog );
      return ( FALSE );
      }

   return ( TRUE );

   }   /* function EditRangeDemoProc */



/*       Name: EditRangeDialogProc
  Description: Dialog Procedure for edit range demo. */

BOOL CALLBACK EditRangeDialogProc( HWND hDlg,
      UINT wMessage, WPARAM wParam, LPARAM lParam )
   {
   HWND hChildWnd;
   LPSTR SpecialChars;

   if ( wMessage == WM_INITDIALOG )
      {

      size_t i;

      /* Initalize all the checkboxes */
      for ( i = IDD_ALNUM; i <= IDD_SPECIAL; i++ )
         {
         SetCheckBox( hDlg, i, TRUE );
         }

      /* Initalize the size of the edit controls */
      SendDlgItemMessage( hDlg, IDD_EDIT_RANGE,
            EM_LIMITTEXT, 255, 0L );
      SendDlgItemMessage( hDlg, IDD_SPECIAL_EDIT,
            EM_LIMITTEXT, 255, 0L );

      /* Initalize the special chars edit field */
      hChildWnd = GetDlgItem( hDlg, IDD_EDIT_RANGE );
      SpecialChars = (LPSTR)GetSubWindowLong(
            hChildWnd, OFFSET_SPECIALCHARS );
      if ( SpecialChars == NULL )
         {
         /* Dynamically allocate memory */
         SpecialChars = (LPSTR)_fcalloc( 1, 256 );
         SetSubWindowLong( hChildWnd,
               OFFSET_SPECIALCHARS,
               (LONG)SpecialChars );
         SetSubWindowWord( hChildWnd,
               OFFSET_MEMFLAG, TRUE );
         }
      hChildWnd = GetDlgItem( hDlg,
            IDD_SPECIAL_EDIT );
      SendMessage( hChildWnd, WM_SETTEXT, 0,
            (LONG)SpecialChars );

      return ( TRUE );

      }   /* if wMessage */

   if ( wMessage != WM_COMMAND )
      {
      /* Return all other messages for
      ** default processing. */
      return ( FALSE );
      }   /* if wMessage */

   /* Process the WM_COMMAND message */

   if ( wParam >= IDD_ALNUM )
      {
      /* Process check boxes */
      SetCheckBox( hDlg, wParam, FALSE );
      return ( TRUE );
      }   /* if wParam */

   if ( wParam == IDD_SPECIAL_EDIT )
      {
      if ( HIWORD( lParam ) == EN_CHANGE )
         {
         /* Get the new special chars */
         hChildWnd = GetDlgItem( hDlg,
               IDD_EDIT_RANGE );
         SpecialChars = (LPSTR)GetSubWindowLong(
               hChildWnd, OFFSET_SPECIALCHARS );
         if ( SpecialChars != NULL )
            {
            GetDlgItemText( hDlg, (int)wParam,
                  SpecialChars, 255 );
            }
         }   /* if HIWORD( lParam ) */
      return ( TRUE );
      }   /* if wPram */

   if ( wParam == IDD_CLOSE )
      {
      hChildWnd = GetDlgItem( hDlg,
               IDD_EDIT_RANGE );
      if ( GetSubWindowWord( hChildWnd,
            OFFSET_MEMFLAG ) )
         {
         /* Free the memory for special chars
         ** if it was allocated in this routine */
         SpecialChars = (LPSTR)GetSubWindowLong(
               hChildWnd, OFFSET_SPECIALCHARS );
         _ffree( SpecialChars );
         }
      EndDialog( hDlg, FALSE );
      return ( TRUE );
      }

   return ( FALSE );

   }   /* function EditRangeDialogProc */


/*****************************************************
       Name: SetCheckBox
Description: Handles the check boxes and the style
             setting.
*****************************************************/
static void SetCheckBox( HWND hDlg, WORD BoxIndex,
      WORD InitFlag )
   {

   HWND hChildWnd;
   WORD Style;
   WORD SingleStyle;
   BOOL Flag;

   SingleStyle = BoxIndex - IDD_ALNUM;
   SingleStyle = 1 << SingleStyle;

   hChildWnd = GetDlgItem( hDlg, IDD_EDIT_RANGE );
   Style = GetSubWindowWord( hChildWnd,
         OFFSET_STYLE );

   if ( SingleStyle & Style )
      {
      /* Style is alread set */
      if ( InitFlag )
         {
         Flag = TRUE;
         }
      else
         {
         /* Reset the style and check box */
         Style &= ~SingleStyle;
         Flag = FALSE;
         }
      }
   else
      {
      /* Style is not set */
      if ( InitFlag )
         {
         Flag = FALSE;
         }
      else
         {
         /* Reset the style and check box */
         Style |= SingleStyle;
         Flag = TRUE;
         }
      }

   if ( !InitFlag )
      {
      SetSubWindowWord( hChildWnd, OFFSET_STYLE,
            Style );
      }

   hChildWnd = GetDlgItem( hDlg, (int)BoxIndex );
   SendMessage( hChildWnd, BM_SETCHECK,
         (WORD)Flag, 0L );

   }   /* funciton SetCheckBox */

/* End of File */
