// wuiname.c - implement TWuiName
// Copyright (c) 1993 by Ron Burk

#include <string.h>
#include <windows.h>
#include "wuistd.h"
#include "wuiname.h"


// Constructor - convert string to TWuiName.
TWuiName::TWuiName(const char *NewName)
    {   MEMBERASSERT();
    if(NewName)
        {
        ASSERT(strlen(NewName) < MAXNAME);
        AtomHandle_ = (short)AddAtom(NewName);
        ASSERT(AtomHandle_ != 0);
        }
    else
        AtomHandle_ = 0;
    }

// Copy constructor - requires string copy.  Gack!
TWuiName::TWuiName(const TWuiName &Other)
    {   MEMBERASSERT();
    char    OtherName[MAXNAME];
    if(Other.AtomHandle_)
        {
        AtomHandle_ = (short)AddAtom(Other.GetName(OtherName));
        ASSERT(AtomHandle_ != 0);
        }
    else
        AtomHandle_ = 0;
    }

// Assignment - standard handle class concerns.
const TWuiName &TWuiName::operator=(const TWuiName &Other)
    {   MEMBERASSERT();
    if(&Other != this)  // account for self-assignment
        {
        if(AtomHandle_)
            DeleteAtom((ATOM)AtomHandle_);
        if(Other.AtomHandle_)
            {
            char    OtherName[MAXNAME];
            AtomHandle_ = (short)AddAtom(Other.GetName(OtherName));
            ASSERT(AtomHandle_ != 0);
            }
        else
            AtomHandle_ = 0;
        }
    return *this;
    }

// Destructor - decrement reference count, delete if zero
TWuiName::~TWuiName()
    {   MEMBERASSERT();
    if(AtomHandle_)
        DeleteAtom((ATOM)AtomHandle_);
    }

// GetName - convert TWuiName back into original string
char *TWuiName::GetName(char *Buffer, int MaxLength) const
    {   MEMBERASSERT();
    ASSERT(Buffer != 0);
    ASSERT(MaxLength >= 0);
    if(AtomHandle_) // if not NULL
        ASSERT2(GetAtomName((ATOM)AtomHandle_, Buffer,
                                           MaxLength) != 0);
    else
        *Buffer = '\0';
    return Buffer;
    }


