// wuiname.h - Class to handle WUIMAN object names.
// Copyright (c) 1993 by Ron Burk

#ifndef WUINAME_H
#define WUINAME_H

#ifndef WUISTD_H
    #include "wuistd.h"
#endif

class   TWuiName
    {
public:
    enum    { MAXNAME = (64+1) };
    TWuiName(const char *NewName=0);
    TWuiName(const TWuiName &Other);
    const TWuiName& operator=(const TWuiName &Other);
   ~TWuiName();
    int operator==(const TWuiName &Other) const;
    int operator!=(const TWuiName &Other) const;
    char   *GetName(char *Buffer,
                           int MaxLength=MAXNAME) const;
private:
    short   AtomHandle_;   // Avoid disclosing it is an ATOM
    };

inline
int     TWuiName::operator==(const TWuiName &Other) const
    {    MEMBERASSERT();
    return Other.AtomHandle_ == AtomHandle_;
    }
inline
int     TWuiName::operator!=(const TWuiName &Other) const
    {    MEMBERASSERT();
    return !(*this == Other);
    }

#endif
